<?php
if (!defined('ABSPATH'))
  {
  exit;
  }
if ( !class_exists( 'Food_Online_Ajax' ) ) {
    /**
		 * Main Class Food_Online_Ajax
		 *
		 * @since 2.0.3
		 */
    class Food_Online_Ajax
    {
            // The Constructor
        public function __construct()
        {

			 $this->reg_my_ajax_methods();
        }
		public function ajaxfdoe_qty_cart() {
	check_ajax_referer( 'fdoe-script-nonce', 'nonce_ajax' );
	$cart_item_key       = isset($_POST['hash']) ? $_POST['hash'] : '';
	$fdoe_product_values = WC()
		->cart
		->get_cart_item($cart_item_key);
	if (empty($fdoe_product_values)) {
		wp_send_json(array(
			'status'      => false
		));
	}
	$fdoe_product_quantity = apply_filters('woocommerce_stock_amount_cart_item', wc_stock_amount(preg_replace('/[^0-9\.]/', '', filter_var($_POST['quantity'], FILTER_SANITIZE_NUMBER_INT))) , $cart_item_key);
	$passed_validation     = apply_filters('woocommerce_update_cart_validation', true, $cart_item_key, $fdoe_product_values, $fdoe_product_quantity);
	$product               = wc_get_product($fdoe_product_values['data']->get_id());





	if ($product->get_max_purchase_quantity() <= $fdoe_product_quantity && $product->get_max_purchase_quantity() != - 1) {
		$fdoe_product_quantity = $product->get_max_purchase_quantity();
	}
	if ($passed_validation) {
		$ok                    = WC()
			->cart
			->set_quantity($cart_item_key, $fdoe_product_quantity, true);
	}

	wp_send_json(array(
		'status' => $ok,
		'product' => $fdoe_product_values['data']->get_id(),
		'is_sold_indi' => $product->is_sold_individually(),
		'try_qty' => $fdoe_product_quantity,


	));
}

public function ajaxfdoe_get_comment_form(){
	check_ajax_referer( 'fdoep-script-nonce', 'nonce_ajax' );
	$id        =  ( $_POST['id']  );
	ob_start();
	$commenter = wp_get_current_commenter();

					$comment_form = array(
						'title_reply_to'       => __( 'Leave a Reply to %s', 'woocommerce' ),
						'title_reply_before'   => '<span id="reply-title" class="comment-reply-title">',
						'title_reply_after'    => '</span>',
						'comment_notes_after'  => '',
						'fields'               => array(
							'author' => '<p class="comment-form-author">' . '<label for="author">' . esc_html__( 'Name', 'woocommerce' ) . '&nbsp;<span class="required">*</span></label> ' .
										'<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" required /></p>',
							'email'  => '<p class="comment-form-email"><label for="email">' . esc_html__( 'Email', 'woocommerce' ) . '&nbsp;<span class="required">*</span></label> ' .
										'<input id="email" name="email" type="email" value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30" required /></p>',
						),
						'label_submit'  => __( 'Submit', 'woocommerce' ),
						'logged_in_as'  => '',
						'comment_field' => '',
					);

					if ( $account_page_url = wc_get_page_permalink( 'myaccount' ) ) {
						$comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf( __( 'You must be <a href="%s">logged in</a> to post a review.', 'woocommerce' ), esc_url( $account_page_url ) ) . '</p>';
					}

					if ( get_option( 'woocommerce_enable_review_rating' ) === 'yes' ) {
						$comment_form['comment_field'] = '<div class="comment-form-rating"><label for="rating">' . esc_html__( 'Your rating', 'woocommerce' ) . '</label><select name="rating" id="rating" required>
							<option value="">' . esc_html__( 'Rate&hellip;', 'woocommerce' ) . '</option>
							<option value="5">' . esc_html__( 'Perfect', 'woocommerce' ) . '</option>
							<option value="4">' . esc_html__( 'Good', 'woocommerce' ) . '</option>
							<option value="3">' . esc_html__( 'Average', 'woocommerce' ) . '</option>
							<option value="2">' . esc_html__( 'Not that bad', 'woocommerce' ) . '</option>
							<option value="1">' . esc_html__( 'Very poor', 'woocommerce' ) . '</option>
						</select></div>';
					}

					$comment_form['comment_field'] .= '<p class="comment-form-comment"><label for="comment">' . esc_html__( 'Your review', 'woocommerce' ) . '&nbsp;<span class="required">*</span></label><textarea id="comment" name="comment" cols="45" rows="5" required></textarea></p>';

				 	comment_form( apply_filters( 'woocommerce_product_review_comment_form_args', $comment_form ), $id );
$content = ob_get_clean();
				$data = array(
					'success' => true,
					'content' => $content,

			) ;

			wp_send_json( $data );
}
public function ajaxfdoe_search_products(){

	check_ajax_referer( 'fdoe-script-nonce', 'nonce_ajax' );
	$exclude_products        =  isset( $_POST['exclude']  ) ? $_POST['exclude'] : array();
	$search_string        =  isset( $_POST['s']  ) ? $_POST['s'] : '';







$the_products = array();
if(!empty($search_string )){
$args =  array(
    'limit' => 5,

    'order' => 'DESC',
	's' => $search_string

);
 $products = wc_get_products( $args );


		foreach($products as $i){

    $the_products[] =  Food_Online_Product2::the_product($i);
}
}
			$data = array(
                                                         'products' => $the_products,


                                                         );
	wp_send_json( $data );
}
public function ajaxfdoe_load_products(){
	check_ajax_referer( 'fdoe-script-nonce', 'nonce_ajax' );
	$mode        =  isset( $_POST['mode']  ) ? $_POST['mode'] : '';
	$exclude_products        =  isset( $_POST['exclude']  ) ? $_POST['exclude'] : array();
	$exclude_cats        =  isset( $_POST['exclude_cats']  ) ? $_POST['exclude_cats'] : array();
	switch($mode){
		case 'fdoe_change_to_pickup':
			$mode_ = 'pickup';
			break;
		case 'fdoe_change_to_delivery':
			$mode_ = 'delivery';
			break;
		case 'fdoe_change_to_eathere':
			$mode_ = 'eathere';
			break;
	}

	$tags_array_raw = Food_Online_Del::get_ava_tags();
	$tags_array = isset($tags_array_raw[$mode_])  ? $tags_array_raw[$mode_] : array();

$cats_array_raw = Food_Online_Del::get_ava_cats();
$cats_array = isset($cats_array_raw[$mode_])  ? $cats_array_raw[$mode_] : array();
$cats_array_slug = array();
  if( is_array($cats_array) && !empty( $cats_array  )){

					$cats_array_slug = self::get_category_objects( $cats_array,'slugs' );
					$cats_to_include = array_diff($cats_array,$exclude_cats);
					  $cats = !empty($cats_to_include)  ? self::get_category_objects( $cats_to_include, 'all' ) : array();

  }




$the_products = array();
if(!empty($cats_array_slug)){
$args = array(
			  'category' =>  $cats_array_slug ,
			   'status' => 'publish',
			   'exclude' => $exclude_products,
			   'limit' => -1
			   );

        $products = wc_get_products( $args );

		foreach($products as $i){

    $the_products[] =  Food_Online_Product2::the_product($i);
}
}
			$data = array(
                                                         'products' => $the_products,
														 'categories' => isset($cats) ? $cats : array(),
														 'cat_ids' => $cats_array,
														  'tag_ids' => $tags_array,


                                                         );
	wp_send_json( $data );
}

	public function ajaxfdoe_make_product_shortcode(){

	check_ajax_referer( 'fdoe-script-nonce', 'nonce_ajax' );
	if ( class_exists( 'YITH_WC_Points_Rewards_Frontend' ) ) {

	do_action('yith_before_product_modal');
}
	do_action('fdoe_before_product_modal');

			$id        =  isset( $_POST['id']  ) ? $_POST['id'] : array();
			$content= [];



			if(!is_countable($id)){return;}
			for ($i = 0; $i <= count($id)-1; $i++) {
				$test_product = wc_get_product(intval($id[$i]));
				$product = !is_null($test_product ) && $test_product  !== false ? $test_product  : false;
				if($product === false){


					continue;
				}
			$content_part =array(

								'type' => $product->get_type( ),
								'price_html' => $product -> get_price_html(),
								'short_description' => $product->get_short_description(),
								'title' => $product -> get_title(),
								 'id' => (int) $id[$i],

								 'single_shortcode' => do_shortcode('[product_page id="' . $id[$i] . '" ]'),
								 'image' => array(

								 'src' => Food_Online_Product::get_image_src($product, $product-> get_type())

               ),
         'sale_badge' =>  $product->is_on_sale()  ? apply_filters( 'woocommerce_sale_flash', '<span class="onsale">' . esc_html__( 'Sale!', 'woocommerce' ) . '</span>', '', $product ) : '',



								 );
			$content[] = $content_part;


			}
			$data = array(
					'success' => true,
					'content' => $content,

			) ;

			wp_send_json( $data );



		}
		public function ajaxfdoe_get_wc_price_2() {
			if (!empty($_POST['price'])) {
				$price    = (floatval($_POST['price']));
				$response = array(
					'price'          => wc_price($price)
				);
			}
			else {
				$response = array(
					'price' => ''
				);
			}
			wp_send_json($response);
		}
		public function ajaxfdoe_get_updated_time() {
			if($_POST['referer'] == 'fdoedel'){
				check_ajax_referer( 'fdoep-script-nonce', 'nonce_ajax' );
			}elseif($_POST['referer'] == 'fdoe'){
				check_ajax_referer( 'fdoe-script-nonce', 'nonce_ajax' );
			}else{
				wp_die();
			}
			 $dynamic_shipippping_time = isset($_POST['deltime']) ? intval(wc_clean($_POST['deltime'])) : false;
                 if($dynamic_shipippping_time !== false){
                    Food_Online_Orders::maybe_set_calculated_shipping_time($dynamic_shipippping_time);
                 }

			ob_start();

			$to_return = Food_Online_Orders::output_order_time();

			$output = ob_get_clean();



			$session_select = class_exists('Food_Online_Del') && get_option('fdoe_enable_delivery_switcher', 'no') != 'no' ? WC()->session->get('fdoe_shipping','') : 'default';


				$response = array(
					'time_html'          => $output,
					'products_not_ok' => $to_return,
					'shipping_session' => $session_select
				);


			wp_send_json($response);
		}

function ajaxfdoe_add(){

	 check_ajax_referer( 'fdoe-script-nonce', 'nonce_ajax' );
	   ob_start();
	    if ( ! isset( $_POST['p_id'] ) ) {
            return;
        }
		 $product_id           = apply_filters('woocommerce_add_to_cart_product_id', absint(sanitize_text_field($_POST['p_id'])));
		 if(WC_Product_Factory::get_product_type( $product_id ) == 'grouped'){

			  $quantity             = empty($_POST['quantity']) ? array() : ($_POST['quantity']);

			  foreach($quantity as $single_product_id => $quant ){
						$product_id = absint( $single_product_id);
						$quantity = wc_stock_amount(wp_unslash($quant));
						 $product_status       = get_post_status($product_id);
						$variation_id         = null;
						$vars = null;


            $variation            = is_null($vars) ||is_bool($vars) ? array() :$vars;
            $status               = true;

						$data[]= self::add_to_cart($product_id, $quantity, $variation_id, $variation, $product_status  );


			  }
			  ob_end_clean();
			  	wp_send_json($data);
				return;
		 }



            $product_id           = apply_filters('woocommerce_add_to_cart_product_id', absint(sanitize_text_field($_POST['p_id'])));


            $quantity             = empty($_POST['quantity']) ? 0 : wc_stock_amount(wp_unslash($_POST['quantity']));

            $product_status       = get_post_status($product_id);
            $variation_id         = empty($_POST['variation_id']) ? 0 : absint(sanitize_text_field($_POST['variation_id']));
			$vars = empty($_POST['variation_atts']) ? array() : json_decode(stripslashes($_POST['variation_atts']),TRUE);


            $variation            = is_null($vars) ||is_bool($vars) ? array() :$vars;
            $status               = true;


            $data = self::add_to_cart($product_id, $quantity, $variation_id, $variation,$product_status  );
			$alert = ob_get_clean();
			$data1 = array_merge($data, array('alert' => $alert));
            wp_send_json($data1);
}

public function add_to_cart($product_id, $quantity, $variation_id, $variation, $product_status  ){
	 $passed_validation    = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity, $variation_id, $variation );
			$cart_item_data = array();
           if ( class_exists( 'WC_Product_Addons_Display' )  ) {

if(!$passed_validation ){
$addon_error = 'addon_error';


}
}
		    $product_quantity_new = $quantity;
            if ($passed_validation && 'publish' === $product_status) {
                $status               = false;
                $product_quantity_new = $quantity;
                if ($variation_id != 0) {
                    $product = wc_get_product($product_id);
                     $variation_product = wc_get_product($variation_id);
					if($variation_product->managing_stock() === true){

                       $product_qty_in_cart = WC()->cart->get_cart_item_quantities();
                        $max_to              = $variation_product->get_max_purchase_quantity();

                        if (array_key_exists($variation_product->get_stock_managed_by_id(), $product_qty_in_cart)) {
                            $in_cart_total = $product_qty_in_cart[$variation_product->get_stock_managed_by_id()];
                        } else {
                            $in_cart_total = 0;
                        }
                        $avalible = ($max_to - $in_cart_total);


                       if($avalible == 0){$product_quantity_new = 0;

						 $overstock               = true;
						}
                        elseif ($quantity > $avalible) {
                            $product_quantity_new = $avalible;
                            $overstock               = true;
                        }elseif($quantity <= $avalible){
							$overstock   = false;
							$product_quantity_new = $quantity;
						}


                    }
                    elseif ($variation_product -> managing_stock() == 'parent') {
                        $product_qty_in_cart = WC()->cart->get_cart_item_quantities();
                        $max_to              = $variation_product->get_max_purchase_quantity();
                       if (array_key_exists($variation_product->get_stock_managed_by_id(), $product_qty_in_cart)) {
                            $in_cart_total = $product_qty_in_cart[$variation_product->get_stock_managed_by_id()] ;
                        } else {
                            $in_cart_total = 0;
                        }
                        $avalible = ($max_to - $in_cart_total);

                       if($avalible == 0){
						$product_quantity_new = 0;

						 $overstock               = true;
						}
                        elseif ($quantity > $avalible) {
                            $product_quantity_new = $avalible;
                            $overstock               = true;
                        }elseif($quantity <= $avalible){
					 $overstock   = false;
							$product_quantity_new = $quantity;
						}
                    }

                }
				// For not variable products
				else{
						 $product = wc_get_product($product_id);
					 if ($product->managing_stock()) {

                        $product_qty_in_cart = WC()->cart->get_cart_item_quantities();
                        $max_to              = $product->get_max_purchase_quantity();
                        if (array_key_exists($product->get_stock_managed_by_id(), $product_qty_in_cart)) {
                            $in_cart_total = $product_qty_in_cart[$product->get_stock_managed_by_id()];
                        } else {
                            $in_cart_total = 0;
                        }
                        $avalible = ($max_to - $in_cart_total);


						if($avalible == 0){
							$product_quantity_new = 0;

						 $overstock               = true;
						}
                        elseif ($quantity > $avalible) {
                            $product_quantity_new = $avalible;
                            $overstock               = true;
                        }elseif($quantity <= $avalible){
						$overstock   = false;
							$product_quantity_new = $quantity;
						}
                    }else{


						$product_quantity_new = $quantity;



					}


				}
				//Check if sold individually

            if ( $product->is_sold_individually() ) {
				  $cart_id = WC()->cart->generate_cart_id( $product_id, $variation_id, $variation, $cart_item_data );


                $cart_item_key =  WC()->cart->find_product_in_cart( $cart_id );


			    $cart_item_data = (array) apply_filters( 'woocommerce_add_cart_item_data', $cart_item_data, $product_id, $variation_id, $product_quantity_new  );
                $product_quantity_new      = apply_filters( 'woocommerce_add_to_cart_sold_individually_quantity', 1, $product_quantity_new, $product_id, $variation_id, $cart_item_data );
                $found_in_cart = apply_filters( 'woocommerce_add_to_cart_sold_individually_found_in_cart', $cart_item_key && WC()->cart->cart_contents[ $cart_item_key ]['quantity'] > 0, $product_id, $variation_id, $cart_item_data, $cart_id );

               foreach( WC()->cart->get_cart() as $cart_item ) {
				$product_in_cart = $cart_item['product_id'];
					if ( $product_in_cart === $product_id ){ $in_cart = true;}else{$in_cart = false;}
				 }
			    if ( $found_in_cart || $in_cart) {

					$is_sold_indi = true;
					$product_quantity_new = 0;
                }
            }
                if ($product_quantity_new > 0) {



                       $hash = WC()->cart->add_to_cart($product_id, $product_quantity_new, $variation_id, $variation);

                    if ($hash != false) {
                        do_action('woocommerce_ajax_added_to_cart', $product_id);

                        do_action('woocommerce_update_cart_action_cart_updated');


                        $data = array(
                            'success' => true,
							'overstock' => isset( $overstock) ? $overstock:false,
							'is_sold_indi'=> isset($is_sold_indi ) ? $is_sold_indi :false,
                            'status' => $status,
                            'product_quantity' => $product_quantity_new,
							'passed_vali' => true

                        );
                    }else{
						$data = array(
                            'success' => false,
							'overstock' => isset( $overstock) ? $overstock:false,
							'is_sold_indi'=> $product->is_sold_individually() ,
                            'status' => $status,
                            'product_quantity' => $product_quantity_new,
							'passed_vali' => false

                        );
					}
                } else {

                    $data = array(
                        'error' => true,
                        'status' => $status,
                        'product_quantity' => $product_quantity_new,
						'overstock' => isset( $overstock) ? $overstock:false,
						'is_sold_indi' => isset($is_sold_indi ) ? $is_sold_indi :false,


					'passed_vali' => false
                    );
                }
            } else {
                $data = array(
                    'error' => true,
                    'status' => isset($addon_error) ? $addon_error : $status,
                    'product_quantity' => $product_quantity_new,
					'passed_vali' => false,
					'overstock' => isset( $overstock) ? $overstock : false,
					'is_sold_indi' => isset($is_sold_indi ) ? $is_sold_indi :false,
                );
            }
			return $data;
}
public static function get_category_objects($cats_array = array(),$fields_ = 'all') {



				$taxonomy       = 'product_cat';
				$orderby        = 'term_order';
				$show_count     = 0; // 1 for yes, 0 for no
				$pad_counts     = 0; // 1 for yes, 0 for no
				$hierarchical   = 1; // 1 for yes, 0 for no
				$title          = '';
				$empty          = 0;
				$fields         = $fields_;
				$includes       = $cats_array;
				$args           = array(
					'taxonomy'                => $taxonomy,
					'menu_order' 			=> 'asc',
					
					'show_count'                => $show_count,
					'pad_counts'                => $pad_counts,
					'hierarchical'                => $hierarchical,
					'title_li'                => $title,
					'hide_empty'                => $empty,
					'fields'                => $fields,
					'include' 				=> $includes,

				);
				$categories_raw = get_categories($args);


				$do_image = (get_option('fdoe_is_prem', 'no') == 'yes' && get_option('fdoe_cat_image', 'no') == 'yes') ? true : false;
					$i = 1;
					foreach ($categories_raw as $fdoe_cat) {
						if(is_object($fdoe_cat)){
						$fdoe_cat->sortIndex = $i;
						$i++;
						$fdoe_cat->id = $fdoe_cat->cat_ID;
						$term_children  = get_term_children(filter_var($fdoe_cat->term_id, FILTER_VALIDATE_INT) , filter_var('product_cat', FILTER_SANITIZE_STRING));
						$parent_count       = 0;
						$fdoe_cat->image    = false;

						$has_sub        = true;
						if (empty($term_children) || is_wp_error($term_children)) {
							$has_sub        = false;

						}else{
							foreach ($term_children as $child_cat) {
								$child = get_term($child_cat, 'product_cat');
							$parent_count       = $parent_count + $child ->count;

						}

						}
						$fdoe_cat->category_count_not_children = $fdoe_cat->category_count - $parent_count ;
						$fdoe_cat->has_sub         = $has_sub;

						if ($do_image){
							$thumbnail_id   = get_term_meta($fdoe_cat->term_id, 'thumbnail_id', true);
						$image          = wp_get_attachment_url($thumbnail_id);
						$fdoe_cat->image           = $image;
						}
					}
}



			return $categories_raw;
		}

public function reg_my_ajax_methods()
  {
  $new_reflex = new ReflectionClass(get_class($this));
  foreach($new_reflex->getMethods() as $method)
   {
   if (strpos($method->name, 'ajaxfdoe') === 0)
    {
    $ref = new ReflectionMethod(get_class($this) , $method->name);
    add_action('wp_ajax_woocommerce_' . $method->name, array(
     $this,
     $method->name
    ) , 10, count($ref->getParameters()));
	 add_action('wp_ajax_nopriv_woocommerce_' . $method->name, array(
     $this,
     $method->name
    ) , 10, count($ref->getParameters()));
	  add_action('wc_ajax_' . $method->name, array(
     $this,
     $method->name
    ) , 10, count($ref->getParameters()));


    }
   }
  }
    }
}
