<div class="wrap">
  <div class="ezr-card ezr-header">
    <img src="<?php echo esc_url( plugins_url( '../assets/ezr-logo.png', __FILE__ ) ); ?>" alt="EZRentOut" />
  </div>
  <div class="ezr-card">
    <h2>Connect your EZRentOut account</h2>
    <p><?php _e("Don't have an EZRentOut account yet? <a href=\"https://www.ezrentout.com/users/sign_up\" target=\"_blank\" rel=\"noopener\">Try it for Free</a>."); ?></p>
    <hr />
    <form name="ezr_widget_form" method="post" action="options.php">
      <?php settings_fields( 'ezr-company-url-settings' ); ?>
      <table class="ezr-form-table">
        <tbody>
          <tr>
            <th>
              <label for="ezr_company_url">EZRentOut Webstore URL</label>
            </th>
            <td>
              <input type="text" name="ezr_company_url" value="<?php echo get_option( 'ezr_company_url' ); ?>" size="20" class="ezr-input-field">
              <p class="description">Get your <b>Webstore URL</b> from your EZRentOut account by heading to <b>Settings > Store Settings > Webstore</b>. Make sure the Webstore is enabled to access the URL.</p>
            </td>
          </tr>
        </tbody>
      </table>
      <div class="ezr-submit">
        <?php submit_button(); ?>  
      </div>
    </form>
  </div>
  <div class="ezr-card">
    <h2>Customize</h2>
    <p><?php _e("Configure your product catalog, availability calendar, cart, and enhance the shopping experience for your customers."); ?></p>
    <hr />
    <a href="https://blog.ezrentout.com/web-store-for-rentals-online-storefront-setup-in-ezrentout/#cart-plugin" target="_blank" rel="noopener"><?php _e("Plugin Handbook"); ?></a>
  </div>
  
</div>
