<?php

/**
 * This is the wrapper template for the html messenger
 *
 * Template Tags:
 *
 * @var string $page_title     The title for the page.
 * @var string $base_css   This is the base css url for a page (should not be changed).
 * @var string $print_css  This is the css url for print copy.
 * @var string $main_css   This is the main css file for the page.
 * @var string $main_body  This is the content generated by the message type templates.
 * @var string $message_type
 *
 * @since 4.5.0
 * @package Event Espresso
 * @subpackage messages
 */

use EventEspresso\core\services\request\sanitizers\AllowedTags;

?>
<!doctype html>
<html>
    <head>
        <title><?php echo wp_strip_all_tags($page_title); ?></title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <?php wp_head(); ?>
        <!-- Base Stylesheet do not change or remove -->
        <link rel="stylesheet" type="text/css" href="<?php echo esc_url_raw($base_css); ?>" media="screen" />
        <!-- Print Style Sheet -->
        <link rel="stylesheet" type="text/css" href="<?php echo esc_url_raw($print_css); ?>" media="print" />
        <!-- Primary Style Sheet -->
        <link rel="stylesheet" type="text/css" href="<?php echo esc_url_raw($main_css); ?>" />
        <!-- Make sure the buttons don't print -->
        <?php if (isset($extra_css)) : ?>
        <!-- Additional Style Sheet -->
        <link rel="stylesheet" type="text/css" href="<?php echo esc_url_raw($extra_css); ?>" />
        <?php endif; ?>
        <style type="text/css">
        @media print{ .noPrint{ display:none !important;height:0!important; width:0!important; margin:0!important; padding:0!important; }}
        </style>
        <?php do_action('AHEE__EE_Html_Messenger_main_wrapper_template_head', $message_type, $page_title, $base_css, $print_css, $main_css, $main_body); ?>
    </head>
    <?php do_action('AHEE__EE_Html_Messenger_main_wrapper_template_header', $message_type, $page_title, $base_css, $print_css, $main_css, $main_body); ?>
    <body>
        <?php do_action('AHEE__EE_Html_Messenger_main_wrapper_template_before_main_body', $message_type, $page_title, $base_css, $print_css, $main_css, $main_body); ?>
        <?php echo wp_kses($main_body, AllowedTags::getWithFormTags()); ?>
        <?php do_action('AHEE__EE_Html_Messenger_main_wrapper_template_after_main_body', $message_type, $page_title, $base_css, $print_css, $main_css, $main_body); ?>
    </body>
    <?php do_action('AHEE__EE_Html_Messenger_main_wrapper_template_footer', $message_type, $page_title, $base_css, $print_css, $main_css, $main_body); ?>
    <?php wp_footer(); ?>
</html>
