<?php
/**
 * Custom CPT Status Selector
 *
 * @var string $cur_status_label
 * @var string $localized_status_save
 * @var string $cur_status
 * @var string[] $statuses
 */
?>
<div id="ee-status-container" style="display: none;">
    <span id="cur_status"><?php echo esc_html($cur_status_label); ?></span>
    <span id="localized_status_save"><?php echo esc_html($localized_status_save); ?></span>
    <span id="cur_stat_id"><?php echo esc_html($cur_status); ?></span>
    <select name='ee_post_status' id='ee_post_status'>
        <?php foreach ($statuses as $status => $label) : ?>
            <option<?php selected($cur_status, $status); ?> value='<?php echo esc_attr($status); ?>'>
                <?php echo esc_html($label); ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>
