<h2 style="text-align: left;"><?php esc_html_e('Who uses Event Espresso?', 'event_espresso'); ?></h2>
<p>
    <?php printf(
        esc_html__(
            'Event Espresso is used by over 40,000 event organizers across the world. They host %sconferences%s, %sart classes%s, training courses, concerts, fundraisers, workshops, %sfilm festivals%s, %spaint and wine%s, and more.',
            'event_espresso'
        ),
        '<a href="https://eventespresso.com/use-cases/conferences/?utm_source=wordpress_org&amp;utm_medium=link&amp;utm_campaign=decaf_about_page&amp;utm_content=Decaf+vs+Regular">',
        '</a>',
        '<a href="https://eventespresso.com/use-cases/art-classes/?utm_source=wordpress_org&amp;utm_medium=link&amp;utm_campaign=decaf_about_page&amp;utm_content=Decaf+vs+Regular">',
        '</a>',
        '<a href="https://eventespresso.com/use-cases/film-festival-ticketing-software/?utm_source=wordpress_org&amp;utm_medium=link&amp;utm_campaign=decaf_about_page&amp;utm_content=Decaf+vs+Regular">',
        '</a>',
        '<a href="https://eventespresso.com/use-cases/paint-wine-party-ticketing-software/?utm_source=wordpress_org&amp;utm_medium=link&amp;utm_campaign=decaf_about_page&amp;utm_content=Decaf+vs+Regular">',
        '</a>'
    ); ?>
</p>

<h2 class="about-headline-callout">
    <?php esc_html_e('Rave Reviews About Event Espresso 4', 'event_espresso'); ?>
</h2>
<p>See what people have to say about the Event Espresso software and support services on
    <a href="http://evts.io/EEDecafFBReviews">Facebook</a>,
    <a href="http://evts.io/EEDecafReviews" target="_blank" rel="noopener noreferrer">WordPress.org</a> and
    <a href="https://eventespresso.com/about/testimonials/">EventEspresso.com</a>:
</p>
<div class="feature-section has-3-columns is-fullwidth three-col">
    <div class="column col">
        <h3>
            <a href="https://wordpress.org/support/topic/amazing-plugin-has-been-running-our-school-for-over-5-years-now/">Amazing
                Plugin – has been running our school for over 5 years now!</a>
        </h3>
        <div class="wporg-ratings" title="5 out of 5 stars" style="color:#ffb900;">
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
        </div>
        <ul>
            <li class="review-body">
                <div class="eventopic type-topic status-publish hentry">
                    <div class="review-topic-content">
                        <p class="review-user-nicename">
                            <a href="https://wordpress.org/support/users/sock2me/"
                               aria-label="View sock2me's profile"
                               class="bbp-author-avatar"
                               rel="nofollow"
                            >
                                <img alt=""
                                     src="https://secure.gravatar.com/avatar/cfe09d3ea7d99f4fd4edc1a2dc5ac0ca?s=100&amp;d=retro&amp;r=g"
                                     srcset="https://secure.gravatar.com/avatar/cfe09d3ea7d99f4fd4edc1a2dc5ac0ca?s=200&amp;d=retro&amp;r=g 2x"
                                     class="avatar avatar-100 photo"
                                     width="100"
                                     height="100"
                                >
                            </a>
                            <br>
                            <a href="https://wordpress.org/support/users/sock2me/"
                               aria-label="View sock2me's profile"
                               class="bbp-author-name"
                               rel="nofollow"
                            >
                                sock2me
                            </a>
                        </p>
                        <p>
                            I started using EE many years ago and we still use it everyday to run our school at
                            <a href="https://portlandfashioninstitute.com" target="_blank" rel="noopener noreferrer
                            nofollow">Portland Sewing</a>.
                            For the cost, there is no other program out there that can do what this does. Their
                            support people are awesome – as is their forum. And they continue to improve the
                            application – you can vote for what features you’d like to add and they reach out to
                            the community for feedback.
                        </p>
                        <p>
                            I highly recommend Event Espresso if you are looking to offer events, classes or really
                            anything that you need to sell seats for. It’s not perfect, but what plugin is? The fact
                            that we can get so much accomplished using this tool is amazing.
                        </p>
                        <p>Thank you team EE (Josh, Garth, Tony &amp; Lorenzo!)</p>

                    </div><!-- .review-topic-content -->
                </div>
            </li><!-- .review-body -->
        </ul>
    </div>
    <div class="column col">
        <h3>
            <a href="https://wordpress.org/support/topic/elegant-event-management-for-wordpress/">
                Elegant event management for WordPress
            </a>
        </h3>
        <div class="wporg-ratings" title="5 out of 5 stars" style="color:#ffb900;">
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
        </div>
        <ul>
            <li class="review-body">
                <div class="even topic type-topic status-publish hentry">
                    <div class="review-topic-content">
                        <p class="review-user-nicename">
                            <a href="https://wordpress.org/support/users/ivycat/"
                               aria-label="View ivycat's profile"
                               class="bbp-author-avatar"
                               rel="nofollow"
                            >
                                <img alt=""
                                     src="https://secure.gravatar.com/avatar/f1c6ff76072edfd217215f3acd412c26?s=100&amp;d=retro&amp;r=g"
                                     srcset="https://secure.gravatar.com/avatar/f1c6ff76072edfd217215f3acd412c26?s=100&amp;d=retro&amp;r=g 2x"
                                     class="avatar avatar-100 photo"
                                     width="100"
                                     height="100"
                                >
                            </a>
                            <br>
                            <a href="https://wordpress.org/support/users/ivycat/"
                               aria-label="View ivycat's profile"
                               class="bbp-author-name"
                               rel="nofollow"
                            >
                                ivycat
                            </a>
                        </p>
                        <p>
                            We&#8217;ve been using and developing sites powered by Event Espresso for several years
                            now. Event Espresso is our go-to for Event Management on WordPress for several reasons:
                        </p>
                        <ol>
                            <li>
                                The team behind the plugin provides outstanding support and are clearly committed to
                                improving the state of Event Management on WordPress.
                            </li>
                            <li>It&#8217;s a solid plugin with a robust codebase and APIs</li>
                            <li>
                                It&#8217;s capable and flexible &#8211; we&#8217;ve used it for everything from
                                concert ticket sales, conference management, calendar management for recovery
                                centers, to walking food tours.
                            </li>
                            <li>They support the WordPress Community in many ways.</li>
                        </ol>
                        <p>Thanks, EE Team &#8211; keep up the great work!</p>
                    </div><!-- .review-topic-content -->
                </div>
            </li><!-- .review-body -->
        </ul>
    </div>
    <div class="column col last-feature">
        <h3>
            <a href="https://wordpress.org/support/topic/the-best-event-plugin-system-we-have-used/">
                The best event plugin system we have used!
            </a>
        </h3>
        <div class="wporg-ratings" title="5 out of 5 stars" style="color:#ffb900;">
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
        </div>
        <ul>
            <li class="review-body">
                <div class="even topic type-topic status-publish hentry">
                    <div class="review-topic-content">
                        <p class="review-user-nicename">
                            <a href="https://wordpress.org/support/users/amandaleigh/"
                               aria-label="View amandaleigh's profile"
                               class="bbp-author-avatar"
                               rel="nofollow"
                            >
                                <img alt=""
                                     src="https://secure.gravatar.com/avatar/a67b47893dd239775d360fd36527d44a?s=100&amp;d=retro&amp;r=g"
                                     srcset="https://secure.gravatar.com/avatar/a67b47893dd239775d360fd36527d44a?s=200&amp;d=retro&amp;r=g 2x"
                                     class="avatar avatar-100 photo"
                                     width="100"
                                     height="100"
                                >
                            </a>
                            <br>
                            <a
                                href="https://wordpress.org/support/users/amandaleigh/"
                                aria-label="View amandaleigh's profile"
                                class="bbp-author-name"
                                rel="nofollow"
                            >
                                amandaleigh
                            </a>
                        </p>
                        <p>
                            We just closed registration for a girls/ladies conference at our church next month. This
                            year we have over 400 registrants and only a few were mail-ins. Everyone else registered
                            on our website, which is running Event Espresso 4. We had to close registration early
                            because we are at capacity! We had fewer duplicate registrations this year than in years
                            past using other software. We also received a lot of compliments on the “new system”.
                            Registrants stated that it was much easier to use than in previous years.
                        </p>
                    </div><!-- .review-topic-content -->
                </div>
            </li><!-- .review-body -->
        </ul>
    </div>

</div>
<?php
if (! defined('EE_CAF_URL')) {
    ?>
    <div align="right">
        <a
            href="https://eventespresso.com/pricing/?utm_source=wordpress_org&amp;utm_medium=link&amp;utm_campaign=decaf_about_page&amp;utm_content=reviews+tab"
            target="_blank"
            class="button button-primary button-hero"
        >
            <span class="dashicons dashicons-cart"></span>
            <?php esc_html_e('Upgrade Now!', 'event_espresso') ?>
        </a>
    </div>
    <?php
}
?>
&nbsp;
<hr/>
<div class="feature-section has-3-columns is-fullwidth three-col">
    <div class="column col">
        <h3>
            <a href="https://wordpress.org/support/topic/using-ee-for-duluth-folk-school-registration/">
                Using EE for Duluth Folk School Registration
            </a>
        </h3>
        <div class="wporg-ratings" title="5 out of 5 stars" style="color:#ffb900;">
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
        </div>
        <ul>
            <li class="review-body">
                <div class="even topic type-topic status-publish hentry">
                    <div class="review-topic-content">
                        <p class="review-user-nicename">
                            <a href="https://wordpress.org/support/users/birchfinch/"
                               aria-label="View Bryan's profile"
                               class="bbp-author-avatar"
                               rel="nofollow"
                            >
                                <img alt=""
                                     src="https://secure.gravatar.com/avatar/6e54429afbe010f3502d67dd19331d79?s=100&amp;d=retro&amp;r=g"
                                     srcset="https://secure.gravatar.com/avatar/6e54429afbe010f3502d67dd19331d79?s=200&amp;d=retro&amp;r=g 2x"
                                     class="avatar avatar-100 photo"
                                     width="100"
                                     height="100"
                                >
                            </a>
                            <br>
                            <a href="https://wordpress.org/support/users/birchfinch/"
                               aria-label="View Bryan's profile"
                               class="bbp-author-name"
                               rel="nofollow"
                            >
                                Bryan
                            </a>
                        </p>
                        <p>
                            We&#8217;ve been using Event Espresso for just over a year now, for the
                            <a href="https://duluthfolkschool.com/" rel="nofollow">Duluth Folk School</a>.
                        </p>
                        <p>
                            EE has a lot of customisability, and solid customer payment options. For us, we bought
                            the &#8216;all the add ons&#8217; option, since we&#8217;re using quite a few different
                            add ons.
                        </p>
                        <p>
                            I do wish it were easier to customize some of the deeply buried text (EE calls them
                            &#8220;People,&#8221; we call them &#8216;Instructors&#8217;, etc.), and I wish it were
                            easier to integrate into our brick and mortar store, where we have inventory (people
                            need two separate transactions if they want to buy a coffee and to register for a
                            class).
                        </p>
                        <p>
                            Overall, it does a good job, and our customers have a pretty easy time figuring it
                            all out.
                        </p>
                    </div><!-- .review-topic-content -->
                </div>
            </li><!-- .review-body -->
        </ul>
    </div>
    <div class="column col">
        <h3><a href="https://wordpress.org/support/topic/excellent-event-plugin-3/">Excellent Event Plugin</a></h3>
        <div class="wporg-ratings" title="5 out of 5 stars" style="color:#ffb900;">
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
        </div>
        <ul>
            <li class="review-body">
                <div class="even topic type-topic status-publish hentry">
                    <div class="review-topic-content">
                        <p class="review-user-nicename">
                            <a href="https://wordpress.org/support/users/elainewildash/"
                               aria-label="View elaine.wildash's profile"
                               class="bbp-author-avatar"
                               rel="nofollow"
                            >
                                <img alt=""
                                     src="https://secure.gravatar.com/avatar/4df4c8f6032eea26398611cf5b76b727?s=100&amp;d=retro&amp;r=g"
                                     srcset="https://secure.gravatar.com/avatar/4df4c8f6032eea26398611cf5b76b727?s=200&amp;d=retro&amp;r=g 2x"
                                     class="avatar avatar-100 photo"
                                     width="100"
                                     height="100"
                                >
                            </a>
                            <br>
                            <a href="https://wordpress.org/support/users/elainewildash/"
                               aria-label="View elaine.wildash's profile"
                               class="bbp-author-name"
                               rel="nofollow"
                            >
                                elaine.wildash
                            </a>
                        </p>
                        <p>
                            Event Espresso was easy to setup and is easy to use. It’s also easy to style for
                            individual websites. It has some really great features – events are simple to setup,
                            events table(s) and calendar which can show colour coded events and simple payment
                            integration. When we started, the plugin was in version 3 (EE3) and we’ve stuck with
                            that however the latest version 4 (EE4) has been completely revamped and comes with
                            added functionality.
                        </p>
                        <p>
                            The support staff have always been very helpful and will work with you when there are
                            issues (even to the point of logging into the back-end of a site) to try to resolve any
                            problems.
                        </p>
                        <p>We look forward to continuing to work with Event Espresso.</p>
                    </div><!-- .review-topic-content -->
                </div>
            </li><!-- .review-body -->
        </ul>
    </div>
    <div class="column col last-feature">
        <h3><a href="https://wordpress.org/support/topic/event-espresso-to-the-max/">Event Espresso to the MAX!</a>
        </h3>
        <div class="wporg-ratings" title="5 out of 5 stars" style="color:#ffb900;">
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
        </div>
        <ul>
            <li class="review-body">
                <div class="even topic type-topic status-publish hentry">
                    <div class="review-topic-content">
                        <p class="review-user-nicename">
                            <a href="https://wordpress.org/support/users/rhj4/"
                               aria-label="View rhj4's profile"
                               class="bbp-author-avatar"
                               rel="nofollow"
                            >
                                <img alt=""
                                     src="https://secure.gravatar.com/avatar/e6fc63d053d69a2afea8e5fb120e639f?s=100&amp;d=retro&amp;r=g"
                                     srcset="https://secure.gravatar.com/avatar/e6fc63d053d69a2afea8e5fb120e639f?s=200&amp;d=retro&amp;r=g 2x"
                                     class="avatar avatar-100 photo"
                                     width="100"
                                     height="100"
                                >
                            </a>
                            <br>
                            <a href="https://wordpress.org/support/users/rhj4/"
                               aria-label="View rhj4's profile"
                               class="bbp-author-name"
                               rel="nofollow"
                            >
                                rhj4
                            </a>
                        </p>
                        <p>
                            I did a pretty exhaustive review of WordPress event management plugins and settled on
                            Event Espresso for two reasons:
                        </p>
                        <ol>
                            <li>It had the richest set of features and capabilities and;</li>
                            <li>Amazing support. Event Espresso is a superb product and I give it top marks.</li>
                        </ol>
                    </div><!-- .review-topic-content -->
                </div>
            </li><!-- .review-body -->
        </ul>
    </div>

</div>
<?php
if (! defined('EE_CAF_URL')) {
    ?>
    <div align="right">
        <a href="https://eventespresso.com/pricing/?utm_source=wordpress_org&amp;utm_medium=link&amp;utm_campaign=decaf_about_page&amp;utm_content=reviews+tab"
           target="_blank"
           class="button button-primary button-hero"
        >
            <span class="dashicons dashicons-cart"></span>
            <?php esc_html_e('Upgrade Now!', 'event_espresso') ?>
        </a>
    </div>
    <?php
}
?>
&nbsp;
<hr/>
<div class="feature-section has-3-columns is-fullwidth three-col">
    <div class="column col">
        <h3>
            <a href="https://wordpress.org/support/topic/a-comprehensive-event-management-plugin/">
                A comprehensive Event management plugin
            </a>
        </h3>
        <div class="wporg-ratings" title="5 out of 5 stars" style="color:#ffb900;">
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
        </div>
        <ul>
            <li class="review-body">
                <div class="even topic type-topic status-publish hentry">
                    <div class="review-topic-content">
                        <p class="review-user-nicename">
                            <a href="https://wordpress.org/support/users/wooninjas/"
                               aria-label="View Wooninjas's profile"
                               class="bbp-author-avatar"
                               rel="nofollow"
                            >
                                <img alt=""
                                     src="https://secure.gravatar.com/avatar/a2424b8ddad190b94f44f2e769c0868a?s=100&amp;d=retro&amp;r=g"
                                     srcset="https://secure.gravatar.com/avatar/a2424b8ddad190b94f44f2e769c0868a?s=200&amp;d=retro&amp;r=g 2x"
                                     class="avatar avatar-100 photo"
                                     width="100"
                                     height="100"
                                >
                            </a>
                            <br>
                            <a
                                href="https://wordpress.org/support/users/wooninjas/"
                                aria-label="View Wooninjas's profile"
                                class="bbp-author-name"
                                rel="nofollow"
                            >
                                Wooninjas
                            </a>
                        </p>
                        <p>
                            With 50+ features including multiple ticketing to Attendee Management and Events
                            Calendar, Event Espresso is the most comprehensive Event Management plugin out there.
                            Although it is a bit complicated and daunting for a non-technical user to configure and
                            set up all the options, people at Event Espresso have done a great job in putting
                            together an extensive documentation to help explain the process. Once you have got the
                            hang of it, you will love it.
                        </p>
                    </div><!-- .review-topic-content -->
                </div>
            </li><!-- .review-body -->
        </ul>
    </div>

    <div class="column col">
        <h3>
            <a href="https://wordpress.org/support/topic/event-espresso-does-it-all/">Event Espresso Does It All</a>
        </h3>
        <div class="wporg-ratings" title="5 out of 5 stars" style="color:#ffb900;">
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
        </div>
        <ul>
            <li class="review-body">
                <div class="even topic type-topic status-publish hentry">
                    <div class="review-topic-content">
                        <p class="review-user-nicename">
                            <a href="https://wordpress.org/support/users/johnmacek/"
                               aria-label="View johnmacek's profile"
                               class="bbp-author-avatar"
                               rel="nofollow"
                            >
                                <img alt=""
                                     src="https://secure.gravatar.com/avatar/5d33ca040695a043d93e8b3df3584f1d?s=100&amp;d=retro&amp;r=g"
                                     srcset="https://secure.gravatar.com/avatar/5d33ca040695a043d93e8b3df3584f1d?s=200&amp;d=retro&amp;r=g 2x"
                                     class="avatar avatar-100 photo"
                                     width="100"
                                     height="100"
                                >
                            </a>
                            <br>
                            <a
                                href="https://wordpress.org/support/users/johnmacek/"
                                aria-label="View johnmacek's profile"
                                class="bbp-author-name"
                                rel="nofollow"
                            >
                                johnmacek
                            </a>
                        </p>
                        <p>
                            I researched a number of Event Ticketing plugins and Event Espresso was the only one that
                            satisfied all my needs. You’ll especially appreciate the wide choice of payment
                            processors you can use. Getting started, support quickly answered all my questions and
                            now I use the forums when I need help.
                        </p>
                    </div><!-- .review-topic-content -->
                </div>
            </li><!-- .review-body -->
        </ul>
    </div>

    <div class="column col last-feature">
        <h3>
            <a href="https://wordpress.org/support/topic/there-is-only-1-event-registration-plugin/">
                There is only 1 Event Registration Plugin!
            </a>
        </h3>
        <div class="wporg-ratings" title="5 out of 5 stars" style="color:#ffb900;">
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
            <span class="dashicons dashicons-star-filled"></span>
        </div>
        <ul>
            <li class="review-body">
                <div class="even topic type-topic status-publish hentry">
                    <div class="review-topic-content">
                        <p class="review-user-nicename">
                            <a href="https://wordpress.org/support/users/10bradders10/"
                               aria-label="View 10bradders10's profile"
                               class="bbp-author-avatar"
                               rel="nofollow"
                            >
                                <img alt=""
                                     src="https://secure.gravatar.com/avatar/a749fba1c0918f408f6760bc18197e62?s=100&amp;d=retro&amp;r=g"
                                     srcset="https://secure.gravatar.com/avatar/a749fba1c0918f408f6760bc18197e62?s=200&amp;d=retro&amp;r=g 2x"
                                     class="avatar avatar-100 photo"
                                     width="100"
                                     height="100"
                                >
                            </a>
                            <br>
                            <a href="https://wordpress.org/support/users/10bradders10/"
                               aria-label="View 10bradders10's profile"
                               class="bbp-author-name"
                               rel="nofollow"
                            >
                                10bradders10
                            </a>
                        </p>
                        <p>After using Event Espresso for several years, this is still the best event registration
                            plugin around to date. The team at Event Espresso continue to be amazing, and I look
                            forward to their next set of enhancements this year!
                        </p>
                    </div><!-- .review-topic-content -->
                </div>
            </li><!-- .review-body -->
        </ul>
    </div>
</div>
<?php
if (! defined('EE_CAF_URL')) {
    ?>
    <div align="right">
        <a href="https://eventespresso.com/pricing/?utm_source=wordpress_org&amp;utm_medium=link&amp;utm_campaign=decaf_about_page&amp;utm_content=reviews+tab"
           target="_blank"
           class="button button-primary button-hero"
        >
            <span class="dashicons dashicons-cart"></span>
            <?php esc_html_e('Upgrade Now!', 'event_espresso') ?>
        </a>
    </div>
    <?php
}
?>