<?php return apply_filters( 'es_demo_listings', array(
    // Luxurious Apartment at Ocean Drive
    array(
        'system' => array(
            'post_title' => 'Luxurious Apartment at Ocean Drive',
            'post_content' => 'Apartment for sale.
This is a demo single property page of Estatik 4.x plugin built for WordPress websites. You can find all the details about the plugin and its version on our website www.estatik.net.
The best luxurious apartment for buy in Miami Beach and on Ocean Drive! Do not miss this deal. Please call us to get more details and book an appointment with your agent.',
            'post_name' => sanitize_title( 'Luxurious Apartment at Ocean Drive' ),
        ),
        'fields' => array(
            'price' => '698000',
            'price_note' => 'For sale by owner',
            'price_per_sqft' => '600',
            'half_baths' => '1',
            'bathrooms' => '2',
            'bedrooms' => '3',
            'total_rooms' => '5',
            'floors' => '1',
            'floor_level' => '1',
            'area' => '350',
            'year_built' => '2003',
            'address' => '750 Ocean Dr, Miami Beach, FL 33139, USA',
            'postal_code' => '33139',
            'latitude' => '25.7776858',
            'longitude' => '-80.13137449999999',
            'address_components' => '[{"long_name":"Ocean Drive","short_name":"Ocean Dr","types":["route"]},{"long_name":"South Beach","short_name":"South Beach","types":["neighborhood","political"]},{"long_name":"Miami Beach","short_name":"Miami Beach","types":["locality","political"]},{"long_name":"Miami-Dade County","short_name":"Miami-Dade County","types":["administrative_area_level_2","political"]},{"long_name":"Florida","short_name":"FL","types":["administrative_area_level_1","political"]},{"long_name":"United States","short_name":"US","types":["country","political"]},{"long_name":"33139","short_name":"33139","types":["postal_code"]}]',
            'es_category' => array( 'For sale' ),
            'es_type' => array( 'Apartment' ),
            'es_label' => array( 'Featured', 'just listed' ),
            'es_status' => array( 'Open' ),
            'es_feature' => array( 'Air conditioning', 'Balcony', 'Elevator', 'Heating', 'Swimming pool', 'Trash Removal', 'Wifi' ),
            'es_amenity' => array( 'Dishwasher', 'Dryer', 'Microwave', 'Oven', 'Refrigerator', 'TV' ),
            'es_neighborhood' => array( 'City center', 'Miami Beach', 'Restaurants', 'Stores' ),
            'es_floor_covering' => array( 'Carpet', 'Slate' ),
            'es_basement' => array( 'Partially finished' ),
            'es_exterior_material' => array( 'Brick', 'Stone' ),
            'es_roof' => array( 'Slate' ),
            'es_parking' => array( 'Garage attached' ),
            'gallery' => array(
                'https://estatik.net/wp-content/uploads/2021/01/1.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/2.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/3.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/4.jpg',
            ),
            'floor_plans' => array(
                'https://estatik.net/wp-content/uploads/2021/01/7e3a1d849d8dbe2a2de1830e5d55d14c-scaled-e1610547659801.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/template-floor-plan.png'
            ),
            'elementary-school' => 'Coconut Grove Elemntary School, Southside Elementary School',
            'secondary-school' => 'Miami Best Secondary School',
            'high-school' => 'Miami Senior High School',
            'garage-spaces' => 2,
            'heating-features' => 'Forced air',
            'cooling' => 'Central',
        )
    ),
    // Multifamily Residential
    array(
        'system' => array(
            'post_title' => 'Multifamily Residential',
            'post_content' => 'Apartment with amazing ocean view.

This is a demo single property page of Estatik 4.x plugin.
Valet, shops, business center, spa, fitness center, sauna jacuzzi, 3 state of the art swimming pools, walk to restaurants, bank, American airlines arena bayside, pharmacies, Whole Foods market. Close to the airport, Miami Adrienne Arsht Center, Perez art…',
            'post_name' => sanitize_title( 'Multifamily Residential' ),
        ),
        'fields' => array(
            'price' => '4395000',
            'price_note' => '',
            'price_per_sqft' => '',
            'half_baths' => '',
            'bathrooms' => '3',
            'bedrooms' => '5',
            'total_rooms' => '',
            'floors' => '2',
            'floor_level' => '3',
            'area' => '',
            'is_open_house' => 1,
            'year_built' => '2014',
            'year_remodeled' => '2020',
            'es_category' => array( 'For sale' ),
            'es_type' => array( 'Apartment' ),
            'es_label' => array( 'Just listed' ),
            'es_status' => array( 'Open' ),
            'es_feature' => array( 'Air conditioning', 'Balcony', 'Elevator', 'Garden', 'Heating', 'Swimming pool', 'Terrace', 'Wifi' ),
            'es_amenity' => array( 'Dishwasher', 'Dryer', 'Garbage disposal', 'Microwave', 'Oven', 'Refrigerator', 'TV', 'Wifi' ),
            'es_neighborhood' => array( 'Miami Beach' ),
            'address' => '924 Marseille Dr, Miami Beach, FL 33141, USA',
            'latitude' => '25.8564068',
            'longitude' => '-80.1291191',
            'address_components' => '[{"long_name":"924","short_name":"924","types":["street_number"]},{"long_name":"Marseille Drive","short_name":"Marseille Dr","types":["route"]},{"long_name":"Normandy Isles","short_name":"Normandy Isles","types":["neighborhood","political"]},{"long_name":"Miami Beach","short_name":"Miami Beach","types":["locality","political"]},{"long_name":"Miami-Dade County","short_name":"Miami-Dade County","types":["administrative_area_level_2","political"]},{"long_name":"Florida","short_name":"FL","types":["administrative_area_level_1","political"]},{"long_name":"United States","short_name":"US","types":["country","political"]},{"long_name":"33141","short_name":"33141","types":["postal_code"]},{"long_name":"2902","short_name":"2902","types":["postal_code_suffix"]}]',
            'gallery' => array(
                'https://estatik.net/wp-content/uploads/2021/01/1-1.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/2-1.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/3-1.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/4-1.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/5.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/6.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/7.jpg',
            ),
        )
    ),
    // Office in business center
    array(
        'system' => array(
            'post_title' => 'Office in business center',
            'post_content' => 'Office for rent.
This is a demo single property page of Estatik 4.x plugin built for WordPress websites. You can find all the details about the plugin and its version on our website www.estatik.net.',
            'post_name' => sanitize_title( 'Office in business center' ),
        ),
        'fields' => array(
            'price' => '5000',
            'price_note' => 'per month',
            'price_per_sqft' => '',
            'half_baths' => '1',
            'bedrooms' => '3',
            'total_rooms' => '4',
            'floor_level' => '10',
            'area' => '350',
            'is_open_house' => 1,
            'is_appointment_only' => 1,
            'appointments' => maybe_unserialize( 'a:2:{i:0;a:3:{s:4:"date";s:8:"12/31/20";s:10:"start_time";s:5:"07:00";s:8:"end_time";s:5:"14:00";}i:1;a:3:{s:4:"date";s:0:"";s:10:"start_time";s:5:"00:00";s:8:"end_time";s:5:"00:00";}}' ),
            'year_built' => '1995',
            'year_remodeled' => '2000',
            'es_category' => array( 'For rent' ),
            'es_type' => array( 'Office' ),
            'es_rent_period' => array( 'Per month' ),
            'es_status' => array( 'Open' ),
            'es_amenity' => array( 'Dishwasher', 'Dryer', 'Microwave', 'Refrigerator', 'TV' ),
            'address' => '8230 W Flagler St, Miami, FL 33144, USA',
            'latitude' => '25.7689571',
            'longitude' => '-80.3290713',
            'postal_code' => '33144',
            'address_components' => 'data-value="[{"long_name":"8230","short_name":"8230","types":["street_number"]},{"long_name":"West Flagler Street","short_name":"W Flagler St","types":["route"]},{"long_name":"Miami","short_name":"Miami","types":["locality","political"]},{"long_name":"Miami-Dade County","short_name":"Miami-Dade County","types":["administrative_area_level_2","political"]},{"long_name":"Florida","short_name":"FL","types":["administrative_area_level_1","political"]},{"long_name":"United States","short_name":"US","types":["country","political"]},{"long_name":"33144","short_name":"33144","types":["postal_code"]},{"long_name":"2069","short_name":"2069","types":["postal_code_suffix"]}]"',
            'gallery' => array(
                'https://estatik.net/wp-content/uploads/2021/01/1-2.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/2-2.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/3-2.jpg',
            ),
            'es_floor_covering' => array( 'Carpet', 'Slate' ),
            'es_basement' => array( 'Finished' ),
            'es_exterior_material' => array( 'Wood' ),
            'es_roof' => array( 'Slate' ),
            'es_parking' => array( 'Garage detached' ),
            'garage-spaces' => 5,
        )
    ),
    // Spectacular house
    array(
        'system' => array(
            'post_title' => 'Spectacular house',
            'post_content' => 'House for sale.
This is a demo single property page of Estatik 4.x plugin.',
            'post_name' => sanitize_title( 'Spectacular house' ),
        ),
        'fields' => array(
            'gallery' => array(
                'https://estatik.net/wp-content/uploads/2021/01/1-3.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/2-3.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/3-3.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/4-2.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/5-1.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/6-1.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/7-1.jpg',
            ),
            'price' => '459000',
            'price_note' => 'For sale by owner',
            'price_per_sqft' => '435',
            'half_baths' => '2',
            'bathrooms' => '2',
            'bedrooms' => '3',
            'total_rooms' => '6',
            'floors' => '2',
            'floor_level' => '2',
            'area' => '679',
            'lot_size' => '14000',
            'year_built' => '2019',
            'year_remodeled' => '2020',
            'is_open_house' => 1,
            'is_appointment_only' => 1,
            'appointments' => maybe_unserialize( 'a:1:{i:0;a:3:{s:4:"date";s:8:"12/25/20";s:10:"start_time";s:5:"17:00";s:8:"end_time";s:5:"19:30";}}' ),
            'address' => '1551 West Ave, Miami Beach, FL 33139, USA',
            'latitude' => '25.7883007',
            'longitude' => '-80.14209509999999',
            'address_components' => '[{"long_name":"1551","short_name":"1551","types":["street_number"]},{"long_name":"West Avenue","short_name":"West Ave","types":["route"]},{"long_name":"South Beach","short_name":"South Beach","types":["neighborhood","political"]},{"long_name":"Miami Beach","short_name":"Miami Beach","types":["locality","political"]},{"long_name":"Miami-Dade County","short_name":"Miami-Dade County","types":["administrative_area_level_2","political"]},{"long_name":"Florida","short_name":"FL","types":["administrative_area_level_1","political"]},{"long_name":"United States","short_name":"US","types":["country","political"]},{"long_name":"33139","short_name":"33139","types":["postal_code"]},{"long_name":"2384","short_name":"2384","types":["postal_code_suffix"]}]',
            'es_category' => array( 'For sale' ),
            'es_type' => array( 'House' ),
            'es_label' => array( 'Featured', 'just listed' ),
            'es_status' => array( 'Open' ),
            'es_feature' => array( 'Air conditioning', 'Balcony', 'Garden', 'Heating', 'Terrace', 'Wifi' ),
            'es_amenity' => array( 'Dishwasher', 'Dryer', 'Microwave', 'Oven', 'Refrigerator', 'TV', 'Wifi' ),
            'es_floor_covering' => array( 'Carpet', 'Softwood' ),
            'es_basement' => array( 'Partially finished' ),
            'es_exterior_material' => array( 'Brick', 'Wood' ),
            'cooling' => 'Central',
            'heating-features' => 'Forced air',
            'es_roof' => array( 'Slate' ),
            'es_parking' => array( 'Garage attached', 'Garage detached' ),
            'elementary-school' => 'Coconut Grove Elemntary School, Southside Elementary School',
            'secondary-school' => 'Miami Senior High School, Jackson High School',
            'garage-spaces' => 2,
        ),
    ),
    // The cosy condo next to the airport and center +
    array(
        'system' => array(
            'post_title' => 'The cosy condo next to the airport and center',
            'post_content' => 'Condo for sale.
This is a demo single property page of Estatik 4.x plugin.
Valet, shops, business center, spa, fitness center, sauna jacuzzi, 3 state of the art swimming pools, walk to restaurants, bank, American airlines arena bayside, pharmacies, Whole Foods market. Close to the airport, Miami Adrienne Arsht Center, Perez art...',
            'post_name' => sanitize_title( 'The cosy condo next to the airport and center' ),
        ),
        'fields' => array(
            'gallery' => array(
                'https://estatik.net/wp-content/uploads/2021/01/1-4.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/2-4.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/3-4.jpg',
            ),
            'price' => '220000',
            'price_note' => 'hot deal',
            'price_per_sqft' => '435',
            'half_baths' => '0',
            'bathrooms' => '2',
            'bedrooms' => '5',
            'total_rooms' => '7',
            'floors' => '2',
            'area' => '700',
            'lot_size' => '506',
            'year_built' => '1998',
            'year_remodeled' => '2020',
            'is_open_house' => 1,
            'is_appointment_only' => 1,
            'appointments' => maybe_unserialize( 'a:2:{i:0;a:3:{s:4:"date";s:8:"12/11/20";s:10:"start_time";s:5:"12:30";s:8:"end_time";s:5:"15:00";}i:1;a:3:{s:4:"date";s:0:"";s:10:"start_time";s:5:"00:00";s:8:"end_time";s:5:"00:00";}}' ),
            'address' => '261 SW 8th St, Miami, FL 33130, USA',
            'latitude' => '25.7666667',
            'longitude' => '-80.1986111',
            'address_components' => '[{"long_name":"261","short_name":"261","types":["street_number"]},{"long_name":"Southwest 8th Street","short_name":"SW 8th St","types":["route"]},{"long_name":"Brickell","short_name":"Brickell","types":["neighborhood","political"]},{"long_name":"Miami","short_name":"Miami","types":["locality","political"]},{"long_name":"Miami-Dade County","short_name":"Miami-Dade County","types":["administrative_area_level_2","political"]},{"long_name":"Florida","short_name":"FL","types":["administrative_area_level_1","political"]},{"long_name":"United States","short_name":"US","types":["country","political"]},{"long_name":"33130","short_name":"33130","types":["postal_code"]}]',
            'es_category' => array( 'For sale' ),
            'es_type' => array( 'Condo' ),
            'es_label' => array( 'Just listed' ),
            'es_status' => array( 'Open' ),
            'es_feature' => array( 'Air conditioning', 'Balcony', 'Bellhop', 'Carbon monoxide detector', 'Elevator', 'Fire alarm', 'Heating', 'Smoke detector', 'Garden', 'Fireplace', 'Terrace', 'Wifi', 'Swimming pool', 'Trash Removal' ),
            'es_amenity' => array( 'Dishwasher', 'Dryer', 'Microwave', 'Oven', 'Refrigerator', 'TV', 'Wifi', 'Garbage disposal', 'Iron', 'Jacuzzi', 'Trash compactor' ),
            'elementary-school' => 'Coconut Grove Elemntary School, Southside Elementary School',
            'secondary-school' => 'Miami Senior High School, Jackson High School',
        ),
    ),
    // Trendy Apartment with Amazing Ocean Views
    array(
        'system' => array(
            'post_title' => 'Trendy Apartment with Amazing Ocean Views',
            'post_content' => 'Apartment with amazing ocean view

This is a demo single property page of Estatik 4.x plugin.
Valet, shops, business center, spa, fitness center, sauna jacuzzi, 3 state of the art swimming pools, walk to restaurants, bank, American airlines arena bayside, pharmacies, Whole Foods market. Close to the airport, Miami Adrienne Arsht Center, Perez art...',
            'post_name' => sanitize_title( 'Trendy Apartment with Amazing Ocean Views' ),
        ),
        'fields' => array(
            'gallery' => array(
                'https://estatik.net/wp-content/uploads/2021/01/1-5.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/2-5.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/3-5.jpg',
                'https://estatik.net/wp-content/uploads/2021/01/4-3.jpg',
            ),
            'price' => '1500',
            'bathrooms' => '2',
            'bedrooms' => '3',
            'total_rooms' => '7',
            'floors' => '2',
            'lot_size' => '400',
            'year_built' => '1998',
            'year_remodeled' => '2020',
            'is_open_house' => 1,
            'is_appointment_only' => 1,
            'appointments' => maybe_unserialize( 'a:2:{i:0;a:3:{s:4:"date";s:8:"12/26/20";s:10:"start_time";s:4:"7:30";s:8:"end_time";s:5:"12:30";}i:1;a:3:{s:4:"date";s:0:"";s:10:"start_time";s:5:"00:00";s:8:"end_time";s:5:"00:00";}}' ),
            'address' => '725 NE 166th St, Miami, FL 33162, USA',
            'latitude' => '25.9279989',
            'longitude' => '-80.18561030000001',
            'address_components' => '[{"long_name":"725","short_name":"725","types":["street_number"]},{"long_name":"Northeast 166th Street","short_name":"NE 166th St","types":["route"]},{"long_name":"Miami","short_name":"Miami","types":["locality","political"]},{"long_name":"Miami-Dade County","short_name":"Miami-Dade County","types":["administrative_area_level_2","political"]},{"long_name":"Florida","short_name":"FL","types":["administrative_area_level_1","political"]},{"long_name":"United States","short_name":"US","types":["country","political"]},{"long_name":"33162","short_name":"33162","types":["postal_code"]},{"long_name":"3683","short_name":"3683","types":["postal_code_suffix"]}]',
            'es_category' => array( 'For rent' ),
            'es_type' => array( 'Apartment' ),
            'es_label' => array( 'Just listed' ),
            'es_status' => array( 'Open' ),
            'es_feature' => array( 'Air conditioning', 'Fire alarm', 'Heating', 'Smoke detector', 'Wifi', 'Swimming pool' ),
            'es_amenity' => array( 'Dishwasher', 'Dryer', 'Microwave', 'Refrigerator', 'TV', 'Wifi' ),
        ),
    ),
) );
