<?php
 namespace tk\GuzzleHttp\Promise; final class Utils { public static function queue(\tk\GuzzleHttp\Promise\TaskQueueInterface $assign = null) { static $queue; if ($assign) { $queue = $assign; } elseif (!$queue) { $queue = new \tk\GuzzleHttp\Promise\TaskQueue(); } return $queue; } public static function task(callable $task) { $queue = self::queue(); $promise = new \tk\GuzzleHttp\Promise\Promise([$queue, 'run']); $queue->add(function () use($task, $promise) { try { $promise->resolve($task()); } catch (\Throwable $e) { $promise->reject($e); } catch (\Exception $e) { $promise->reject($e); } }); return $promise; } public static function inspect(\tk\GuzzleHttp\Promise\PromiseInterface $promise) { try { return ['state' => \tk\GuzzleHttp\Promise\PromiseInterface::FULFILLED, 'value' => $promise->wait()]; } catch (\tk\GuzzleHttp\Promise\RejectionException $e) { return ['state' => \tk\GuzzleHttp\Promise\PromiseInterface::REJECTED, 'reason' => $e->getReason()]; } catch (\Throwable $e) { return ['state' => \tk\GuzzleHttp\Promise\PromiseInterface::REJECTED, 'reason' => $e]; } catch (\Exception $e) { return ['state' => \tk\GuzzleHttp\Promise\PromiseInterface::REJECTED, 'reason' => $e]; } } public static function inspectAll($promises) { $results = []; foreach ($promises as $key => $promise) { $results[$key] = inspect($promise); } return $results; } public static function unwrap($promises) { $results = []; foreach ($promises as $key => $promise) { $results[$key] = $promise->wait(); } return $results; } public static function all($promises, $recursive = \false) { $results = []; $promise = \tk\GuzzleHttp\Promise\Each::of($promises, function ($value, $idx) use(&$results) { $results[$idx] = $value; }, function ($reason, $idx, \tk\GuzzleHttp\Promise\Promise $aggregate) { $aggregate->reject($reason); })->then(function () use(&$results) { \ksort($results); return $results; }); if (\true === $recursive) { $promise = $promise->then(function ($results) use($recursive, &$promises) { foreach ($promises as $promise) { if (\tk\GuzzleHttp\Promise\Is::pending($promise)) { return self::all($promises, $recursive); } } return $results; }); } return $promise; } public static function some($count, $promises) { $results = []; $rejections = []; return \tk\GuzzleHttp\Promise\Each::of($promises, function ($value, $idx, \tk\GuzzleHttp\Promise\PromiseInterface $p) use(&$results, $count) { if (\tk\GuzzleHttp\Promise\Is::settled($p)) { return; } $results[$idx] = $value; if (\count($results) >= $count) { $p->resolve(null); } }, function ($reason) use(&$rejections) { $rejections[] = $reason; })->then(function () use(&$results, &$rejections, $count) { if (\count($results) !== $count) { throw new \tk\GuzzleHttp\Promise\AggregateException('Not enough promises to fulfill count', $rejections); } \ksort($results); return \array_values($results); }); } public static function any($promises) { return self::some(1, $promises)->then(function ($values) { return $values[0]; }); } public static function settle($promises) { $results = []; return \tk\GuzzleHttp\Promise\Each::of($promises, function ($value, $idx) use(&$results) { $results[$idx] = ['state' => \tk\GuzzleHttp\Promise\PromiseInterface::FULFILLED, 'value' => $value]; }, function ($reason, $idx) use(&$results) { $results[$idx] = ['state' => \tk\GuzzleHttp\Promise\PromiseInterface::REJECTED, 'reason' => $reason]; })->then(function () use(&$results) { \ksort($results); return $results; }); } } 