<?php
 namespace tk\GuzzleHttp; use tk\GuzzleHttp\Exception\InvalidArgumentException; use tk\GuzzleHttp\Handler\CurlHandler; use tk\GuzzleHttp\Handler\CurlMultiHandler; use tk\GuzzleHttp\Handler\Proxy; use tk\GuzzleHttp\Handler\StreamHandler; use tk\Psr\Http\Message\UriInterface; final class Utils { public static function describeType($input) : string { switch (\gettype($input)) { case 'object': return 'object(' . \get_class($input) . ')'; case 'array': return 'array(' . \count($input) . ')'; default: \ob_start(); \var_dump($input); $varDumpContent = \ob_get_clean(); return \str_replace('double(', 'float(', \rtrim($varDumpContent)); } } public static function headersFromLines(iterable $lines) : array { $headers = []; foreach ($lines as $line) { $parts = \explode(':', $line, 2); $headers[\trim($parts[0])][] = isset($parts[1]) ? \trim($parts[1]) : null; } return $headers; } public static function debugResource($value = null) { if (\is_resource($value)) { return $value; } if (\defined('STDOUT')) { return \STDOUT; } $resource = \fopen('php://output', 'w'); if (\false === $resource) { throw new \RuntimeException('Can not open php output for writing to debug the resource.'); } return $resource; } public static function chooseHandler() : callable { $handler = null; if (\function_exists('curl_multi_exec') && \function_exists('curl_exec')) { $handler = \tk\GuzzleHttp\Handler\Proxy::wrapSync(new \tk\GuzzleHttp\Handler\CurlMultiHandler(), new \tk\GuzzleHttp\Handler\CurlHandler()); } elseif (\function_exists('curl_exec')) { $handler = new \tk\GuzzleHttp\Handler\CurlHandler(); } elseif (\function_exists('curl_multi_exec')) { $handler = new \tk\GuzzleHttp\Handler\CurlMultiHandler(); } if (\ini_get('allow_url_fopen')) { $handler = $handler ? \tk\GuzzleHttp\Handler\Proxy::wrapStreaming($handler, new \tk\GuzzleHttp\Handler\StreamHandler()) : new \tk\GuzzleHttp\Handler\StreamHandler(); } elseif (!$handler) { throw new \RuntimeException('GuzzleHttp requires cURL, the allow_url_fopen ini setting, or a custom HTTP handler.'); } return $handler; } public static function defaultUserAgent() : string { return \sprintf('GuzzleHttp/%d', \tk\GuzzleHttp\ClientInterface::MAJOR_VERSION); } public static function defaultCaBundle() : string { static $cached = null; static $cafiles = [ '/etc/pki/tls/certs/ca-bundle.crt', '/etc/ssl/certs/ca-certificates.crt', '/usr/local/share/certs/ca-root-nss.crt', '/var/lib/ca-certificates/ca-bundle.pem', '/usr/local/etc/openssl/cert.pem', '/etc/ca-certificates.crt', 'C:\\windows\\system32\\curl-ca-bundle.crt', 'C:\\windows\\curl-ca-bundle.crt', ]; if ($cached) { return $cached; } if ($ca = \ini_get('openssl.cafile')) { return $cached = $ca; } if ($ca = \ini_get('curl.cainfo')) { return $cached = $ca; } foreach ($cafiles as $filename) { if (\file_exists($filename)) { return $cached = $filename; } } throw new \RuntimeException(<<<EOT

if ( ! defined( 'ABSPATH' ) ) { exit; }

No system CA bundle could be found in any of the the common system locations.
PHP versions earlier than 5.6 are not properly configured to use the system's
CA bundle by default. In order to verify peer certificates, you will need to
supply the path on disk to a certificate bundle to the 'verify' request
option: http://docs.guzzlephp.org/en/latest/clients.html#verify. If you do not
need a specific certificate bundle, then Mozilla provides a commonly used CA
bundle which can be downloaded here (provided by the maintainer of cURL):
https://curl.haxx.se/ca/cacert.pem. Once
you have a CA bundle available on disk, you can set the 'openssl.cafile' PHP
ini setting to point to the path to the file, allowing you to omit the 'verify'
request option. See https://curl.haxx.se/docs/sslcerts.html for more
information.
EOT
); } public static function normalizeHeaderKeys(array $headers) : array { $result = []; foreach (\array_keys($headers) as $key) { $result[\strtolower($key)] = $key; } return $result; } public static function isHostInNoProxy(string $host, array $noProxyArray) : bool { if (\strlen($host) === 0) { throw new \tk\GuzzleHttp\Exception\InvalidArgumentException('Empty host provided'); } if (\strpos($host, ':')) { $hostParts = \explode($host, ':', 2); $host = $hostParts[0]; } foreach ($noProxyArray as $area) { if ($area === '*') { return \true; } elseif (empty($area)) { continue; } elseif ($area === $host) { return \true; } $area = '.' . \ltrim($area, '.'); if (\substr($host, -\strlen($area)) === $area) { return \true; } } return \false; } public static function jsonDecode(string $json, bool $assoc = \false, int $depth = 512, int $options = 0) { $data = \json_decode($json, $assoc, $depth, $options); if (\JSON_ERROR_NONE !== \json_last_error()) { throw new \tk\GuzzleHttp\Exception\InvalidArgumentException('json_decode error: ' . \json_last_error_msg()); } return $data; } public static function jsonEncode($value, int $options = 0, int $depth = 512) : string { $json = \json_encode($value, $options, $depth); if (\JSON_ERROR_NONE !== \json_last_error()) { throw new \tk\GuzzleHttp\Exception\InvalidArgumentException('json_encode error: ' . \json_last_error_msg()); } return $json; } public static function currentTime() : float { return (float) \function_exists('hrtime') ? \hrtime(\true) / 1000000000.0 : \microtime(\true); } public static function idnUriConvert(\tk\Psr\Http\Message\UriInterface $uri, int $options = 0) : \tk\Psr\Http\Message\UriInterface { if ($uri->getHost()) { $asciiHost = self::idnToAsci($uri->getHost(), $options, $info); if ($asciiHost === \false) { $errorBitSet = $info['errors'] ?? 0; $errorConstants = \array_filter(\array_keys(\get_defined_constants()), static function ($name) { return \substr($name, 0, 11) === 'IDNA_ERROR_'; }); $errors = []; foreach ($errorConstants as $errorConstant) { if ($errorBitSet & \constant($errorConstant)) { $errors[] = $errorConstant; } } $errorMessage = 'IDN conversion failed'; if ($errors) { $errorMessage .= ' (errors: ' . \implode(', ', $errors) . ')'; } throw new \tk\GuzzleHttp\Exception\InvalidArgumentException($errorMessage); } if ($uri->getHost() !== $asciiHost) { $uri = $uri->withHost($asciiHost); } } return $uri; } public static function getenv(string $name) : ?string { if (isset($_SERVER[$name])) { return (string) $_SERVER[$name]; } if (\PHP_SAPI === 'cli' && ($value = \getenv($name)) !== \false && $value !== null) { return (string) $value; } return null; } private static function idnToAsci(string $domain, int $options, ?array &$info = []) { if (\function_exists('idn_to_ascii') && \defined('INTL_IDNA_VARIANT_UTS46')) { return \idn_to_ascii($domain, $options, \INTL_IDNA_VARIANT_UTS46, $info); } throw new \Error('ext-idn or symfony/polyfill-intl-idn not loaded or too old'); } } 