<?php
 namespace tk\GuzzleHttp; use tk\GuzzleHttp\Promise as P; use tk\GuzzleHttp\Promise\PromiseInterface; use tk\Psr\Http\Message\RequestInterface; use tk\Psr\Http\Message\ResponseInterface; class RetryMiddleware { private $nextHandler; private $decider; private $delay; public function __construct(callable $decider, callable $nextHandler, callable $delay = null) { $this->decider = $decider; $this->nextHandler = $nextHandler; $this->delay = $delay ?: __CLASS__ . '::exponentialDelay'; } public static function exponentialDelay(int $retries) : int { return (int) \pow(2, $retries - 1) * 1000; } public function __invoke(\tk\Psr\Http\Message\RequestInterface $request, array $options) : \tk\GuzzleHttp\Promise\PromiseInterface { if (!isset($options['retries'])) { $options['retries'] = 0; } $fn = $this->nextHandler; return $fn($request, $options)->then($this->onFulfilled($request, $options), $this->onRejected($request, $options)); } private function onFulfilled(\tk\Psr\Http\Message\RequestInterface $request, array $options) : callable { return function ($value) use($request, $options) { if (!($this->decider)($options['retries'], $request, $value, null)) { return $value; } return $this->doRetry($request, $options, $value); }; } private function onRejected(\tk\Psr\Http\Message\RequestInterface $req, array $options) : callable { return function ($reason) use($req, $options) { if (!($this->decider)($options['retries'], $req, null, $reason)) { return \tk\GuzzleHttp\Promise\Create::rejectionFor($reason); } return $this->doRetry($req, $options); }; } private function doRetry(\tk\Psr\Http\Message\RequestInterface $request, array $options, \tk\Psr\Http\Message\ResponseInterface $response = null) : \tk\GuzzleHttp\Promise\PromiseInterface { $options['delay'] = ($this->delay)(++$options['retries'], $response); return $this($request, $options); } } 