<?php

if ( ! defined( 'ABSPATH' ) ) { exit; }

 if ( ! function_exists( 'fs_normalize_path' ) ) { if ( function_exists( 'wp_normalize_path' ) ) { function fs_normalize_path( $path ) { return wp_normalize_path( $path ); } } else { function fs_normalize_path( $path ) { $path = str_replace( '\\', '/', $path ); $path = preg_replace( '|/+|', '/', $path ); return $path; } } } require_once dirname( __FILE__ ) . '/supplements/fs-essential-functions-2.2.1.php'; if ( ! function_exists( 'fs_redirect' ) ) { function fs_redirect( $location, $exit = true, $status = 302 ) { global $is_IIS; $file = ''; $line = ''; if ( headers_sent($file, $line) ) { if ( WP_FS__DEBUG_SDK && class_exists( 'FS_Admin_Notices' ) ) { $notices = FS_Admin_Notices::instance( 'global' ); $notices->add( "Freemius failed to redirect the page because the headers have been already sent from line <b><code>{$line}</code></b> in file <b><code>{$file}</code></b>. If it's unexpected, it usually happens due to invalid space and/or EOL character(s).", 'Oops...', 'error' ); } return false; } if ( defined( 'DOING_AJAX' ) ) { return false; } if ( ! $location ) { return false; } $location = fs_sanitize_redirect( $location ); if ( $is_IIS ) { header( "Refresh: 0;url=$location" ); } else { if ( php_sapi_name() != 'cgi-fcgi' ) { status_header( $status ); } header( "Location: $location" ); } if ( $exit ) { exit(); } return true; } if ( ! function_exists( 'fs_sanitize_redirect' ) ) { function fs_sanitize_redirect( $location ) { $location = preg_replace( '|[^a-z0-9-~+_.?#=&;,/:%!]|i', '', $location ); $location = fs_kses_no_null( $location ); $strip = array( '%0d', '%0a' ); $found = true; while ( $found ) { $found = false; foreach ( (array) $strip as $val ) { while ( strpos( $location, $val ) !== false ) { $found = true; $location = str_replace( $val, '', $location ); } } } return $location; } } if ( ! function_exists( 'fs_kses_no_null' ) ) { function fs_kses_no_null( $string ) { $string = preg_replace( '/\0+/', '', $string ); $string = preg_replace( '/(\\\\0)+/', '', $string ); return $string; } } } if ( ! function_exists( 'fs_get_ip' ) ) { function fs_get_ip() { return empty( $_SERVER[ 'SERVER_ADDR' ] ) ? null : $_SERVER[ 'SERVER_ADDR' ]; } } function fs_find_caller_plugin_file() { if ( ! function_exists( 'get_plugins' ) ) { require_once ABSPATH . 'wp-admin/includes/plugin.php'; } $all_plugins = fs_get_plugins( true ); $all_plugins_paths = array(); foreach ( $all_plugins as $relative_path => $data ) { $all_plugins_paths[] = fs_normalize_path( realpath( WP_PLUGIN_DIR . '/' . $relative_path ) ); } $plugin_file = null; for ( $i = 1, $bt = debug_backtrace(), $len = count( $bt ); $i < $len; $i ++ ) { if ( empty( $bt[ $i ]['file'] ) ) { continue; } if ( in_array( fs_normalize_path( $bt[ $i ]['file'] ), $all_plugins_paths ) ) { $plugin_file = $bt[ $i ]['file']; break; } } if ( is_null( $plugin_file ) ) { wp_die( 'Freemius SDK couldn\'t find the plugin\'s main file. Please contact sdk@freemius.com with the current error.', 'Error', array( 'back_link' => true ) ); } return $plugin_file; } require_once dirname( __FILE__ ) . '/supplements/fs-essential-functions-1.1.7.1.php'; function fs_update_sdk_newest_version( $sdk_relative_path, $plugin_file = false ) { global $fs_active_plugins; $newest_sdk = $fs_active_plugins->plugins[ $sdk_relative_path ]; if ( ! is_string( $plugin_file ) ) { $plugin_file = plugin_basename( fs_find_caller_plugin_file() ); } if ( ! isset( $newest_sdk->type ) || 'theme' !== $newest_sdk->type ) { if ( ! function_exists( 'is_plugin_active' ) ) { require_once ABSPATH . 'wp-admin/includes/plugin.php'; } $in_activation = ( ! is_plugin_active( $plugin_file ) ); } else { $theme = wp_get_theme(); $in_activation = ( $newest_sdk->plugin_path == $theme->stylesheet ); } $fs_active_plugins->newest = (object) array( 'plugin_path' => $plugin_file, 'sdk_path' => $sdk_relative_path, 'version' => $newest_sdk->version, 'in_activation' => $in_activation, 'timestamp' => time(), ); update_option( 'fs_active_plugins', $fs_active_plugins ); } function fs_newest_sdk_plugin_first() { global $fs_active_plugins; $newest_sdk_plugin_path = $fs_active_plugins->newest->plugin_path; $active_plugins = get_option( 'active_plugins', array() ); $updated_active_plugins = array( $newest_sdk_plugin_path ); $plugin_found = false; $is_first_path = true; foreach ( $active_plugins as $key => $plugin_path ) { if ( $plugin_path === $newest_sdk_plugin_path ) { if ( $is_first_path ) { return false; } $plugin_found = true; continue; } $updated_active_plugins[] = $plugin_path; if ( $is_first_path ) { $is_first_path = false; } } if ( $plugin_found ) { update_option( 'active_plugins', $updated_active_plugins ); return true; } if ( is_multisite() ) { $network_active_plugins = get_site_option( 'active_sitewide_plugins', array() ); if ( isset( $network_active_plugins[ $newest_sdk_plugin_path ] ) ) { reset( $network_active_plugins ); if ( $newest_sdk_plugin_path === key( $network_active_plugins ) ) { return false; } else { $time = $network_active_plugins[ $newest_sdk_plugin_path ]; unset( $network_active_plugins[ $newest_sdk_plugin_path ] ); $network_active_plugins = array( $newest_sdk_plugin_path => $time ) + $network_active_plugins; update_site_option( 'active_sitewide_plugins', $network_active_plugins ); return true; } } } return false; } function fs_fallback_to_newest_active_sdk() { global $fs_active_plugins; $newest_sdk_data = null; $newest_sdk_path = null; foreach ( $fs_active_plugins->plugins as $sdk_relative_path => $data ) { if ( is_null( $newest_sdk_data ) || version_compare( $data->version, $newest_sdk_data->version, '>' ) ) { if ( 'plugin' === $data->type ) { $is_module_active = is_plugin_active( $data->plugin_path ); } else { $active_theme = wp_get_theme(); $is_module_active = ( $data->plugin_path === $active_theme->get_template() ); } $is_sdk_exists = file_exists( fs_normalize_path( WP_PLUGIN_DIR . '/' . $sdk_relative_path . '/start.php' ) ); if ( ! $is_module_active || ! $is_sdk_exists ) { unset( $fs_active_plugins->plugins[ $sdk_relative_path ] ); } else { $newest_sdk_data = $data; $newest_sdk_path = $sdk_relative_path; } } } if ( is_null( $newest_sdk_data ) ) { $fs_active_plugins = new stdClass(); update_option( 'fs_active_plugins', $fs_active_plugins ); } else { fs_update_sdk_newest_version( $newest_sdk_path, $newest_sdk_data->plugin_path ); } }