<?php

if ( ! defined( 'ABSPATH' ) ) { exit; }

 if ( ! defined( 'ABSPATH' ) ) { exit; } class FS_Plugin_License extends FS_Entity { public $plugin_id; public $user_id; public $plan_id; public $parent_plan_name; public $parent_plan_title; public $parent_license_id; public $products; public $pricing_id; public $quota; public $activated; public $activated_local; public $expiration; public $secret_key; public $is_whitelabeled; public $is_free_localhost; public $is_block_features; public $is_cancelled; function __construct( $license = false ) { parent::__construct( $license ); } static function get_type() { return 'license'; } function left() { if ( ! $this->is_features_enabled() ) { return 0; } if ( $this->is_unlimited() ) { return 999; } return ( $this->quota - $this->activated - ( $this->is_free_localhost ? 0 : $this->activated_local ) ); } function is_single_site() { return ( is_numeric( $this->quota ) && 1 == $this->quota ); } function is_expired() { return ! $this->is_lifetime() && ( strtotime( $this->expiration ) < WP_FS__SCRIPT_START_TIME ); } function is_valid() { return ! $this->is_expired(); } function is_lifetime() { return is_null( $this->expiration ); } function is_unlimited() { return is_null( $this->quota ); } function is_utilized( $is_localhost = null ) { if ( is_null( $is_localhost ) ) { $is_localhost = WP_FS__IS_LOCALHOST_FOR_SERVER; } if ( $this->is_unlimited() ) { return false; } return ! ( $this->is_free_localhost && $is_localhost ) && ( $this->quota <= $this->activated + ( $this->is_free_localhost ? 0 : $this->activated_local ) ); } function can_activate( $is_localhost = null ) { return ! $this->is_utilized( $is_localhost ) && $this->is_features_enabled(); } function can_activate_bulk( $production_count, $localhost_count ) { if ( $this->is_unlimited() ) { return true; } return ( $this->quota >= $this->activated + $production_count + ( $this->is_free_localhost ? 0 : $this->activated_local + $localhost_count ) ); } function is_active() { return ( ! $this->is_cancelled ); } function is_features_enabled() { return $this->is_active() && ( ! $this->is_block_features || ! $this->is_expired() ); } function is_first_payment_pending() { return ( WP_FS__TIME_24_HOURS_IN_SEC >= strtotime( $this->expiration ) - strtotime( $this->created ) ); } function total_activations() { return ( $this->activated + $this->activated_local ); } function get_html_escaped_masked_secret_key() { return self::mask_secret_key_for_html( $this->secret_key ); } static function mask_secret_key_for_html( $secret_key ) { return ( htmlspecialchars( substr( $secret_key, 0, 6 ) ) . str_pad( '', ( strlen( $secret_key ) - 9 ) * 6, '&bull;' ) . htmlspecialchars( substr( $secret_key, - 3 ) ) ); } } 