"use strict";
/**
 *   Support Functions - Spin Icon in Buttons  ------------------------------------------------------------------ */

/**
 * Remove spin icon from  button and Enable this button.
 *
 * @param button_clicked_element_id		- HTML ID attribute of this button
 * @return string						- CSS classes that was previously in button icon
 */

function wpbc_button__remove_spin(button_clicked_element_id) {
  var previos_classes = '';

  if (undefined != button_clicked_element_id && '' != button_clicked_element_id) {
    var jElement = jQuery('#' + button_clicked_element_id);

    if (jElement.length) {
      previos_classes = wpbc_button_disable_loading_icon(jElement.get(0));
    }
  }

  return previos_classes;
}
/**
 * Show Loading (rotating arrow) icon for button that has been clicked
 *
 * @param this_button		- this object of specific button
 * @return string			- CSS classes that was previously in button icon
 */


function wpbc_button_enable_loading_icon(this_button) {
  var jButton = jQuery(this_button);
  var jIcon = jButton.find('i');
  var previos_classes = jIcon.attr('class');
  jIcon.removeClass().addClass('menu_icon icon-1x wpbc_icn_rotate_right wpbc_spin'); // Set Rotate icon
  //jIcon.addClass( 'wpbc_animation_pause' );												// Pause animation
  //jIcon.addClass( 'wpbc_ui_red' );														// Set icon color red

  jIcon.attr('wpbc_previous_class', previos_classes);
  jButton.addClass('disabled'); // Disable button
  //jButton.prop( "disabled", true );
  // We need to  set  here attr instead of prop, because for A elements,  attribute 'disabled' do  not added with jButton.prop( "disabled", true );

  jButton.attr('wpbc_previous_onclick', jButton.attr('onclick')); //Save this value

  jButton.attr('onclick', ''); // Disable actions "on click"

  return previos_classes;
}
/**
 * Hide Loading (rotating arrow) icon for button that was clicked and show previous icon and enable button
 *
 * @param this_button		- this object of specific button
 * @return string			- CSS classes that was previously in button icon
 */


function wpbc_button_disable_loading_icon(this_button) {
  var jButton = jQuery(this_button);
  var jIcon = jButton.find('i');
  var previos_classes = jIcon.attr('wpbc_previous_class');

  if (undefined != previos_classes && '' != previos_classes) {
    jIcon.removeClass().addClass(previos_classes);
  }

  jButton.removeClass('disabled'); // Remove Disable button

  var previous_onclick = jButton.attr('wpbc_previous_onclick');

  if (undefined != previous_onclick && '' != previous_onclick) {
    jButton.attr('onclick', previous_onclick);
  }

  return previos_classes;
}
/**
 * Blink specific HTML element to set attention to this element.
 *
 * @param {string} element_to_blink		  - class or id of element: '.wpbc_widget_available_unavailable'
 * @param {int} how_many_times			  - 4
 * @param {int} how_long_to_blink		  - 350
 */


function wpbc_blink_element(element_to_blink) {
  var how_many_times = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 4;
  var how_long_to_blink = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 350;

  for (var i = 0; i < how_many_times; i++) {
    jQuery(element_to_blink).fadeOut(how_long_to_blink).fadeIn(how_long_to_blink);
  }

  jQuery(element_to_blink).animate({
    opacity: 1
  }, 500);
}
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
