<?php
/**
 * Subscriber
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * BigCommerce API
 *
 * A Swagger Document for the BigCommmerce v3 API.
 *
 * OpenAPI spec version: 3.0.0b
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Model;

use \ArrayAccess;

class Subscriber extends SubscriberBase implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Subscriber';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'int',
        'email' => 'string',
        'first_name' => 'string',
        'last_name' => 'string',
        'source' => 'string',
        'order_id' => 'int',
        'date_modified' => '\DateTime',
        'date_created' => '\DateTime'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'email' => 'email',
        'first_name' => 'first_name',
        'last_name' => 'last_name',
        'source' => 'source',
        'order_id' => 'order_id',
        'date_modified' => 'date_modified',
        'date_created' => 'date_created'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'email' => 'setEmail',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'source' => 'setSource',
        'order_id' => 'setOrderId',
        'date_modified' => 'setDateModified',
        'date_created' => 'setDateCreated'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'email' => 'getEmail',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'source' => 'getSource',
        'order_id' => 'getOrderId',
        'date_modified' => 'getDateModified',
        'date_created' => 'getDateCreated'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = [])
    {
        $this->container['id'] = array_key_exists('id', $data) ? $data['id'] : null;
        $this->container['email'] = array_key_exists('email', $data) ? $data['email'] : null;
        $this->container['first_name'] = array_key_exists('first_name', $data) ? $data['first_name'] : null;
        $this->container['last_name'] = array_key_exists('last_name', $data) ? $data['last_name'] : null;
        $this->container['source'] = array_key_exists('source', $data) ? $data['source'] : null;
        $this->container['order_id'] = array_key_exists('order_id', $data) ? $data['order_id'] : null;
        $this->container['date_modified'] = array_key_exists('date_modified', $data) ? $data['date_modified'] : null;
        $this->container['date_created'] = array_key_exists('date_created', $data) ? $data['date_created'] : null;
    }

    /**
     * returns container
     * @return array
     */
    public function get()
    {
        return $this->container;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        if (strlen($this->container['first_name']) > 255) {
            $invalid_properties[] = "invalid value for 'first_name', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['first_name']) < 0) {
            $invalid_properties[] = "invalid value for 'first_name', the character length must be bigger than or equal to 0.";
        }
        if (strlen($this->container['last_name']) > 255) {
            $invalid_properties[] = "invalid value for 'last_name', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['last_name']) < 0) {
            $invalid_properties[] = "invalid value for 'last_name', the character length must be bigger than or equal to 0.";
        }
        if (strlen($this->container['source']) > 255) {
            $invalid_properties[] = "invalid value for 'source', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['source']) < 0) {
            $invalid_properties[] = "invalid value for 'source', the character length must be bigger than or equal to 0.";
        }
        if ($this->container['order_id'] > 2147483647) {
            $invalid_properties[] = "invalid value for 'order_id', must be smaller than or equal to 2147483647.";
        }
        if ($this->container['order_id'] < 1) {
            $invalid_properties[] = "invalid value for 'order_id', must be bigger than or equal to 1.";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if (strlen($this->container['first_name']) > 255) {
            return false;
        }
        if (strlen($this->container['first_name']) < 0) {
            return false;
        }
        if (strlen($this->container['last_name']) > 255) {
            return false;
        }
        if (strlen($this->container['last_name']) < 0) {
            return false;
        }
        if (strlen($this->container['source']) > 255) {
            return false;
        }
        if (strlen($this->container['source']) < 0) {
            return false;
        }
        if ($this->container['order_id'] > 2147483647) {
            return false;
        }
        if ($this->container['order_id'] < 1) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param int $id The unique numeric ID of the subscriber; increments sequentially.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets email
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     * @param string $email The email of the subscriber. Must be unique.
     * @return $this
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets first_name
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     * @param string $first_name The first name of the subscriber.
     * @return $this
     */
    public function setFirstName($first_name)
    {
        if (strlen($first_name) > 255) {
            throw new \InvalidArgumentException('invalid length for $first_name when calling Subscriber., must be smaller than or equal to 255.');
        }
        if (strlen($first_name) < 0) {
            throw new \InvalidArgumentException('invalid length for $first_name when calling Subscriber., must be bigger than or equal to 0.');
        }
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     * @return string
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     * @param string $last_name The last name of the subscriber.
     * @return $this
     */
    public function setLastName($last_name)
    {
        if (strlen($last_name) > 255) {
            throw new \InvalidArgumentException('invalid length for $last_name when calling Subscriber., must be smaller than or equal to 255.');
        }
        if (strlen($last_name) < 0) {
            throw new \InvalidArgumentException('invalid length for $last_name when calling Subscriber., must be bigger than or equal to 0.');
        }
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets source
     * @return string
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     * @param string $source The source of the subscriber. Values are: `storefront`, `order`, or `custom`.
     * @return $this
     */
    public function setSource($source)
    {
        if (strlen($source) > 255) {
            throw new \InvalidArgumentException('invalid length for $source when calling Subscriber., must be smaller than or equal to 255.');
        }
        if (strlen($source) < 0) {
            throw new \InvalidArgumentException('invalid length for $source when calling Subscriber., must be bigger than or equal to 0.');
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets order_id
     * @return int
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     * @param int $order_id The ID of the source order, if source was an order.
     * @return $this
     */
    public function setOrderId($order_id)
    {

        if ($order_id > 2147483647) {
            throw new \InvalidArgumentException('invalid value for $order_id when calling Subscriber., must be smaller than or equal to 2147483647.');
        }
        if ($order_id < 1) {
            throw new \InvalidArgumentException('invalid value for $order_id when calling Subscriber., must be bigger than or equal to 1.');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets date_modified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param \DateTime $date_modified The date on which the subscriber was modified.
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets date_created
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param \DateTime $date_created The date of which the subscriber was created.
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this));
    }
}


