<?php
/**
 * Channel
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * BigCommerce Channels API
 *
 * The Channels API enables you to create and manage listings across a BigCommerce merchant's sales channels.
 *
 * OpenAPI spec version: 1.0
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Model;

use \ArrayAccess;

class Channel implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Channel';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'int',
        'type' => 'string',
        'platform' => 'string',
        'name' => 'string',
        'date_created' => 'string',
        'date_modified' => 'string',
        'external_id' => 'string',
        'is_listable_from_ui' => 'bool',
        'is_visible' => 'bool',
        'status' => 'string',
        'config_meta' => '\BigCommerce\Api\v3\Model\ChannelConfigMeta'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'type' => 'type',
        'platform' => 'platform',
        'name' => 'name',
        'date_created' => 'date_created',
        'date_modified' => 'date_modified',
        'external_id' => 'external_id',
        'is_listable_from_ui' => 'is_listable_from_ui',
        'is_visible' => 'is_visible',
        'status' => 'status',
        'config_meta' => 'config_meta'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'type' => 'setType',
        'platform' => 'setPlatform',
        'name' => 'setName',
        'date_created' => 'setDateCreated',
        'date_modified' => 'setDateModified',
        'external_id' => 'setExternalId',
        'is_listable_from_ui' => 'setIsListableFromUi',
        'is_visible' => 'setIsVisible',
        'status' => 'setStatus',
        'config_meta' => 'setConfigMeta'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'type' => 'getType',
        'platform' => 'getPlatform',
        'name' => 'getName',
        'date_created' => 'getDateCreated',
        'date_modified' => 'getDateModified',
        'external_id' => 'getExternalId',
        'is_listable_from_ui' => 'getIsListableFromUi',
        'is_visible' => 'getIsVisible',
        'status' => 'getStatus',
        'config_meta' => 'getConfigMeta'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    const STATUS_PRELAUNCH = 'prelaunch';
    const STATUS_ACTIVE = 'active';
    const STATUS_INACTIVE = 'inactive';
    const STATUS_CONNECTED = 'connected';
    const STATUS_DISCONNECTED = 'disconnected';
    const STATUS_ARCHIVED = 'archived';
    const STATUS_DELETED = 'deleted';
    const STATUS_TERMINATED = 'terminated';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_PRELAUNCH,
            self::STATUS_ACTIVE,
            self::STATUS_INACTIVE,
            self::STATUS_CONNECTED,
            self::STATUS_DISCONNECTED,
            self::STATUS_ARCHIVED,
            self::STATUS_DELETED,
            self::STATUS_TERMINATED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = [])
    {
        $this->container['id'] = array_key_exists('id', $data) ? $data['id'] : null;
        $this->container['type'] = array_key_exists('type', $data) ? $data['type'] : null;
        $this->container['platform'] = array_key_exists('platform', $data) ? $data['platform'] : null;
        $this->container['name'] = array_key_exists('name', $data) ? $data['name'] : null;
        $this->container['date_created'] = array_key_exists('date_created', $data) ? $data['date_created'] : null;
        $this->container['date_modified'] = array_key_exists('date_modified', $data) ? $data['date_modified'] : null;
        $this->container['external_id'] = array_key_exists('external_id', $data) ? $data['external_id'] : null;
        $this->container['is_listable_from_ui'] = array_key_exists('is_listable_from_ui', $data) ? $data['is_listable_from_ui'] : null;
        $this->container['is_visible'] = array_key_exists('is_visible', $data) ? $data['is_visible'] : null;
        $this->container['status'] = array_key_exists('status', $data) ? $data['status'] : null;
        $this->container['config_meta'] = array_key_exists('config_meta', $data) ? $data['config_meta'] : null;
    }

    /**
     * returns container
     * @return array
     */
    public function get()
    {
        return $this->container;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        $allowed_values = ["prelaunch", "active", "inactive", "connected", "disconnected", "archived", "deleted", "terminated"];
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        $allowed_values = ["prelaunch", "active", "inactive", "connected", "disconnected", "archived", "deleted", "terminated"];
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param int $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets platform
     * @return string
     */
    public function getPlatform()
    {
        return $this->container['platform'];
    }

    /**
     * Sets platform
     * @param string $platform
     * @return $this
     */
    public function setPlatform($platform)
    {
        $this->container['platform'] = $platform;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets date_created
     * @return string
     */
    public function getDateCreated()
    {
        return $this->container['date_created'];
    }

    /**
     * Sets date_created
     * @param string $date_created
     * @return $this
     */
    public function setDateCreated($date_created)
    {
        $this->container['date_created'] = $date_created;

        return $this;
    }

    /**
     * Gets date_modified
     * @return string
     */
    public function getDateModified()
    {
        return $this->container['date_modified'];
    }

    /**
     * Sets date_modified
     * @param string $date_modified
     * @return $this
     */
    public function setDateModified($date_modified)
    {
        $this->container['date_modified'] = $date_modified;

        return $this;
    }

    /**
     * Gets external_id
     * @return string
     */
    public function getExternalId()
    {
        return $this->container['external_id'];
    }

    /**
     * Sets external_id
     * @param string $external_id
     * @return $this
     */
    public function setExternalId($external_id)
    {
        $this->container['external_id'] = $external_id;

        return $this;
    }

    /**
     * Gets is_listable_from_ui
     * @return bool
     */
    public function getIsListableFromUi()
    {
        return $this->container['is_listable_from_ui'];
    }

    /**
     * Sets is_listable_from_ui
     * @param bool $is_listable_from_ui
     * @return $this
     */
    public function setIsListableFromUi($is_listable_from_ui)
    {
        $this->container['is_listable_from_ui'] = $is_listable_from_ui;

        return $this;
    }

    /**
     * Gets is_visible
     * @return bool
     */
    public function getIsVisible()
    {
        return $this->container['is_visible'];
    }

    /**
     * Sets is_visible
     * @param bool $is_visible
     * @return $this
     */
    public function setIsVisible($is_visible)
    {
        $this->container['is_visible'] = $is_visible;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = ['prelaunch', 'active', 'inactive', 'connected', 'disconnected', 'archived', 'deleted', 'terminated'];
        if (!is_null($status) && (!in_array($status, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'prelaunch', 'active', 'inactive', 'connected', 'disconnected', 'archived', 'deleted', 'terminated'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets config_meta
     * @return \BigCommerce\Api\v3\Model\ChannelConfigMeta
     */
    public function getConfigMeta()
    {
        return $this->container['config_meta'];
    }

    /**
     * Sets config_meta
     * @param \BigCommerce\Api\v3\Model\ChannelConfigMeta $config_meta
     * @return $this
     */
    public function setConfigMeta($config_meta)
    {
        $this->container['config_meta'] = $config_meta;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this));
    }
}


