<?php
/**
 * Cart
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * Data Model for BigCommerce's v3 Server-to-Server Cart API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: v0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Model;

use \ArrayAccess;

class Cart implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Cart';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'string',
        'customer_id' => 'int',
        'channel_id' => 'int',
        'email' => 'string',
        'currency' => '\BigCommerce\Api\v3\Model\Currency',
        'tax_included' => 'bool',
        'base_amount' => 'float',
        'discount_amount' => 'float',
        'cart_amount' => 'float',
        'coupons' => '\BigCommerce\Api\v3\Model\AppliedCoupon[]',
        'discounts' => '\BigCommerce\Api\v3\Model\AppliedDiscount[]',
        'line_items' => '\BigCommerce\Api\v3\Model\LineItems',
        'created_time' => 'string',
        'updated_time' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'customer_id' => 'customer_id',
        'channel_id' => 'channel_id',
        'email' => 'email',
        'currency' => 'currency',
        'tax_included' => 'tax_included',
        'base_amount' => 'base_amount',
        'discount_amount' => 'discount_amount',
        'cart_amount' => 'cart_amount',
        'coupons' => 'coupons',
        'discounts' => 'discounts',
        'line_items' => 'line_items',
        'created_time' => 'created_time',
        'updated_time' => 'updated_time'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'customer_id' => 'setCustomerId',
        'channel_id' => 'setChannelId',
        'email' => 'setEmail',
        'currency' => 'setCurrency',
        'tax_included' => 'setTaxIncluded',
        'base_amount' => 'setBaseAmount',
        'discount_amount' => 'setDiscountAmount',
        'cart_amount' => 'setCartAmount',
        'coupons' => 'setCoupons',
        'discounts' => 'setDiscounts',
        'line_items' => 'setLineItems',
        'created_time' => 'setCreatedTime',
        'updated_time' => 'setUpdatedTime'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'customer_id' => 'getCustomerId',
        'channel_id' => 'getChannelId',
        'email' => 'getEmail',
        'currency' => 'getCurrency',
        'tax_included' => 'getTaxIncluded',
        'base_amount' => 'getBaseAmount',
        'discount_amount' => 'getDiscountAmount',
        'cart_amount' => 'getCartAmount',
        'coupons' => 'getCoupons',
        'discounts' => 'getDiscounts',
        'line_items' => 'getLineItems',
        'created_time' => 'getCreatedTime',
        'updated_time' => 'getUpdatedTime'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = [])
    {
        $this->container['id'] = array_key_exists('id', $data) ? $data['id'] : null;
        $this->container['customer_id'] = array_key_exists('customer_id', $data) ? $data['customer_id'] : null;
        $this->container['channel_id'] = array_key_exists('channel_id', $data) ? $data['channel_id'] : null;
        $this->container['email'] = array_key_exists('email', $data) ? $data['email'] : null;
        $this->container['currency'] = array_key_exists('currency', $data) ? $data['currency'] : null;
        $this->container['tax_included'] = array_key_exists('tax_included', $data) ? $data['tax_included'] : null;
        $this->container['base_amount'] = array_key_exists('base_amount', $data) ? $data['base_amount'] : null;
        $this->container['discount_amount'] = array_key_exists('discount_amount', $data) ? $data['discount_amount'] : null;
        $this->container['cart_amount'] = array_key_exists('cart_amount', $data) ? $data['cart_amount'] : null;
        $this->container['coupons'] = array_key_exists('coupons', $data) ? $data['coupons'] : null;
        $this->container['discounts'] = array_key_exists('discounts', $data) ? $data['discounts'] : null;
        $this->container['line_items'] = array_key_exists('line_items', $data) ? $data['line_items'] : null;
        $this->container['created_time'] = array_key_exists('created_time', $data) ? $data['created_time'] : null;
        $this->container['updated_time'] = array_key_exists('updated_time', $data) ? $data['updated_time'] : null;
    }

    /**
     * returns container
     * @return array
     */
    public function get()
    {
        return $this->container;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id Cart ID, provided after creating a cart with a POST.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets customer_id
     * @return int
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     * @param int $customer_id ID of the customer to which the cart belongs.
     * @return $this
     */
    public function setCustomerId($customer_id)
    {
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets channel_id
     * @return int
     */
    public function getChannelId()
    {
        return $this->container['channel_id'];
    }

    /**
     * Sets channel_id
     * @param int $channel_id
     * @return $this
     */
    public function setChannelId($channel_id)
    {
        $this->container['channel_id'] = $channel_id;

        return $this;
    }

    /**
     * Gets email
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     * @param string $email The cart's email. This is the same email that is used in the billing address
     * @return $this
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets currency
     * @return \BigCommerce\Api\v3\Model\Currency
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     * @param \BigCommerce\Api\v3\Model\Currency $currency
     * @return $this
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets tax_included
     * @return bool
     */
    public function getTaxIncluded()
    {
        return $this->container['tax_included'];
    }

    /**
     * Sets tax_included
     * @param bool $tax_included
     * @return $this
     */
    public function setTaxIncluded($tax_included)
    {
        $this->container['tax_included'] = $tax_included;

        return $this;
    }

    /**
     * Gets base_amount
     * @return float
     */
    public function getBaseAmount()
    {
        return $this->container['base_amount'];
    }

    /**
     * Sets base_amount
     * @param float $base_amount Cost of cart's contents, before applying discounts.
     * @return $this
     */
    public function setBaseAmount($base_amount)
    {
        $this->container['base_amount'] = $base_amount;

        return $this;
    }

    /**
     * Gets discount_amount
     * @return float
     */
    public function getDiscountAmount()
    {
        return $this->container['discount_amount'];
    }

    /**
     * Sets discount_amount
     * @param float $discount_amount Discounted amount.
     * @return $this
     */
    public function setDiscountAmount($discount_amount)
    {
        $this->container['discount_amount'] = $discount_amount;

        return $this;
    }

    /**
     * Gets cart_amount
     * @return float
     */
    public function getCartAmount()
    {
        return $this->container['cart_amount'];
    }

    /**
     * Sets cart_amount
     * @param float $cart_amount Sum of line-items amounts, minus cart-level discounts and coupons. This amount includes taxes (where applicable).
     * @return $this
     */
    public function setCartAmount($cart_amount)
    {
        $this->container['cart_amount'] = $cart_amount;

        return $this;
    }

    /**
     * Gets coupons
     * @return \BigCommerce\Api\v3\Model\AppliedCoupon[]
     */
    public function getCoupons()
    {
        return $this->container['coupons'];
    }

    /**
     * Sets coupons
     * @param \BigCommerce\Api\v3\Model\AppliedCoupon[] $coupons
     * @return $this
     */
    public function setCoupons($coupons)
    {
        $this->container['coupons'] = $coupons;

        return $this;
    }

    /**
     * Gets discounts
     * @return \BigCommerce\Api\v3\Model\AppliedDiscount[]
     */
    public function getDiscounts()
    {
        return $this->container['discounts'];
    }

    /**
     * Sets discounts
     * @param \BigCommerce\Api\v3\Model\AppliedDiscount[] $discounts
     * @return $this
     */
    public function setDiscounts($discounts)
    {
        $this->container['discounts'] = $discounts;

        return $this;
    }

    /**
     * Gets line_items
     * @return \BigCommerce\Api\v3\Model\LineItems
     */
    public function getLineItems()
    {
        return $this->container['line_items'];
    }

    /**
     * Sets line_items
     * @param \BigCommerce\Api\v3\Model\LineItems $line_items
     * @return $this
     */
    public function setLineItems($line_items)
    {
        $this->container['line_items'] = $line_items;

        return $this;
    }

    /**
     * Gets created_time
     * @return string
     */
    public function getCreatedTime()
    {
        return $this->container['created_time'];
    }

    /**
     * Sets created_time
     * @param string $created_time Time when the cart was created.
     * @return $this
     */
    public function setCreatedTime($created_time)
    {
        $this->container['created_time'] = $created_time;

        return $this;
    }

    /**
     * Gets updated_time
     * @return string
     */
    public function getUpdatedTime()
    {
        return $this->container['updated_time'];
    }

    /**
     * Sets updated_time
     * @param string $updated_time Time when the cart was last updated.
     * @return $this
     */
    public function setUpdatedTime($updated_time)
    {
        $this->container['updated_time'] = $updated_time;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this));
    }
}


