<?php
/**
 * AddressForCustomer
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * BigCommerce API
 *
 * A Swagger Document for the BigCommmerce v3 API.
 *
 * OpenAPI spec version: 3.0.0b
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Model;

use \ArrayAccess;

class AddressForCustomer implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Address For Customer';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'first_name' => 'string',
        'last_name' => 'string',
        'company' => 'string',
        'address1' => 'string',
        'address2' => 'string',
        'city' => 'string',
        'state_or_province' => 'string',
        'postal_code' => 'string',
        'country_code' => 'string',
        'phone' => 'string',
        'address_type' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'first_name' => 'first_name',
        'last_name' => 'last_name',
        'company' => 'company',
        'address1' => 'address1',
        'address2' => 'address2',
        'city' => 'city',
        'state_or_province' => 'state_or_province',
        'postal_code' => 'postal_code',
        'country_code' => 'country_code',
        'phone' => 'phone',
        'address_type' => 'address_type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'company' => 'setCompany',
        'address1' => 'setAddress1',
        'address2' => 'setAddress2',
        'city' => 'setCity',
        'state_or_province' => 'setStateOrProvince',
        'postal_code' => 'setPostalCode',
        'country_code' => 'setCountryCode',
        'phone' => 'setPhone',
        'address_type' => 'setAddressType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'company' => 'getCompany',
        'address1' => 'getAddress1',
        'address2' => 'getAddress2',
        'city' => 'getCity',
        'state_or_province' => 'getStateOrProvince',
        'postal_code' => 'getPostalCode',
        'country_code' => 'getCountryCode',
        'phone' => 'getPhone',
        'address_type' => 'getAddressType'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    const ADDRESS_TYPE_RESIDENTIAL = 'residential';
    const ADDRESS_TYPE_COMMERCIAL = 'commercial';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAddressTypeAllowableValues()
    {
        return [
            self::ADDRESS_TYPE_RESIDENTIAL,
            self::ADDRESS_TYPE_COMMERCIAL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = [])
    {
        $this->container['first_name'] = array_key_exists('first_name', $data) ? $data['first_name'] : null;
        $this->container['last_name'] = array_key_exists('last_name', $data) ? $data['last_name'] : null;
        $this->container['company'] = array_key_exists('company', $data) ? $data['company'] : null;
        $this->container['address1'] = array_key_exists('address1', $data) ? $data['address1'] : null;
        $this->container['address2'] = array_key_exists('address2', $data) ? $data['address2'] : null;
        $this->container['city'] = array_key_exists('city', $data) ? $data['city'] : null;
        $this->container['state_or_province'] = array_key_exists('state_or_province', $data) ? $data['state_or_province'] : null;
        $this->container['postal_code'] = array_key_exists('postal_code', $data) ? $data['postal_code'] : null;
        $this->container['country_code'] = array_key_exists('country_code', $data) ? $data['country_code'] : null;
        $this->container['phone'] = array_key_exists('phone', $data) ? $data['phone'] : null;
        $this->container['address_type'] = array_key_exists('address_type', $data) ? $data['address_type'] : null;
    }

    /**
     * returns container
     * @return array
     */
    public function get()
    {
        return $this->container;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        if ($this->container['first_name'] === null) {
            $invalid_properties[] = "'first_name' can't be null";
        }
        if (strlen($this->container['first_name']) > 255) {
            $invalid_properties[] = "invalid value for 'first_name', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['first_name']) < 1) {
            $invalid_properties[] = "invalid value for 'first_name', the character length must be bigger than or equal to 1.";
        }
        if ($this->container['last_name'] === null) {
            $invalid_properties[] = "'last_name' can't be null";
        }
        if (strlen($this->container['last_name']) > 255) {
            $invalid_properties[] = "invalid value for 'last_name', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['last_name']) < 1) {
            $invalid_properties[] = "invalid value for 'last_name', the character length must be bigger than or equal to 1.";
        }
        if (strlen($this->container['company']) > 255) {
            $invalid_properties[] = "invalid value for 'company', the character length must be smaller than or equal to 255.";
        }
        if (strlen($this->container['company']) < 0) {
            $invalid_properties[] = "invalid value for 'company', the character length must be bigger than or equal to 0.";
        }
        if ($this->container['address1'] === null) {
            $invalid_properties[] = "'address1' can't be null";
        }
        if ($this->container['city'] === null) {
            $invalid_properties[] = "'city' can't be null";
        }
        if (strlen($this->container['city']) > 100) {
            $invalid_properties[] = "invalid value for 'city', the character length must be smaller than or equal to 100.";
        }
        if (strlen($this->container['city']) < 0) {
            $invalid_properties[] = "invalid value for 'city', the character length must be bigger than or equal to 0.";
        }
        if ($this->container['state_or_province'] === null) {
            $invalid_properties[] = "'state_or_province' can't be null";
        }
        if (strlen($this->container['state_or_province']) > 100) {
            $invalid_properties[] = "invalid value for 'state_or_province', the character length must be smaller than or equal to 100.";
        }
        if (strlen($this->container['state_or_province']) < 0) {
            $invalid_properties[] = "invalid value for 'state_or_province', the character length must be bigger than or equal to 0.";
        }
        if ($this->container['postal_code'] === null) {
            $invalid_properties[] = "'postal_code' can't be null";
        }
        if (strlen($this->container['postal_code']) > 30) {
            $invalid_properties[] = "invalid value for 'postal_code', the character length must be smaller than or equal to 30.";
        }
        if (strlen($this->container['postal_code']) < 0) {
            $invalid_properties[] = "invalid value for 'postal_code', the character length must be bigger than or equal to 0.";
        }
        if ($this->container['country_code'] === null) {
            $invalid_properties[] = "'country_code' can't be null";
        }
        if (strlen($this->container['country_code']) > 2) {
            $invalid_properties[] = "invalid value for 'country_code', the character length must be smaller than or equal to 2.";
        }
        if (strlen($this->container['country_code']) < 2) {
            $invalid_properties[] = "invalid value for 'country_code', the character length must be bigger than or equal to 2.";
        }
        if (strlen($this->container['phone']) > 50) {
            $invalid_properties[] = "invalid value for 'phone', the character length must be smaller than or equal to 50.";
        }
        if (strlen($this->container['phone']) < 0) {
            $invalid_properties[] = "invalid value for 'phone', the character length must be bigger than or equal to 0.";
        }
        $allowed_values = ["residential", "commercial"];
        if (!in_array($this->container['address_type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'address_type', must be one of #{allowed_values}.";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['first_name'] === null) {
            return false;
        }
        if (strlen($this->container['first_name']) > 255) {
            return false;
        }
        if (strlen($this->container['first_name']) < 1) {
            return false;
        }
        if ($this->container['last_name'] === null) {
            return false;
        }
        if (strlen($this->container['last_name']) > 255) {
            return false;
        }
        if (strlen($this->container['last_name']) < 1) {
            return false;
        }
        if (strlen($this->container['company']) > 255) {
            return false;
        }
        if (strlen($this->container['company']) < 0) {
            return false;
        }
        if ($this->container['address1'] === null) {
            return false;
        }
        if ($this->container['city'] === null) {
            return false;
        }
        if (strlen($this->container['city']) > 100) {
            return false;
        }
        if (strlen($this->container['city']) < 0) {
            return false;
        }
        if ($this->container['state_or_province'] === null) {
            return false;
        }
        if (strlen($this->container['state_or_province']) > 100) {
            return false;
        }
        if (strlen($this->container['state_or_province']) < 0) {
            return false;
        }
        if ($this->container['postal_code'] === null) {
            return false;
        }
        if (strlen($this->container['postal_code']) > 30) {
            return false;
        }
        if (strlen($this->container['postal_code']) < 0) {
            return false;
        }
        if ($this->container['country_code'] === null) {
            return false;
        }
        if (strlen($this->container['country_code']) > 2) {
            return false;
        }
        if (strlen($this->container['country_code']) < 2) {
            return false;
        }
        if (strlen($this->container['phone']) > 50) {
            return false;
        }
        if (strlen($this->container['phone']) < 0) {
            return false;
        }
        $allowed_values = ["residential", "commercial"];
        if (!in_array($this->container['address_type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets first_name
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     * @param string $first_name The first name of the customer address.
     * @return $this
     */
    public function setFirstName($first_name)
    {
        if (strlen($first_name) > 255) {
            throw new \InvalidArgumentException('invalid length for $first_name when calling AddressForCustomer., must be smaller than or equal to 255.');
        }
        if (strlen($first_name) < 1) {
            throw new \InvalidArgumentException('invalid length for $first_name when calling AddressForCustomer., must be bigger than or equal to 1.');
        }
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     * @return string
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     * @param string $last_name The last name of the customer address.
     * @return $this
     */
    public function setLastName($last_name)
    {
        if (strlen($last_name) > 255) {
            throw new \InvalidArgumentException('invalid length for $last_name when calling AddressForCustomer., must be smaller than or equal to 255.');
        }
        if (strlen($last_name) < 1) {
            throw new \InvalidArgumentException('invalid length for $last_name when calling AddressForCustomer., must be bigger than or equal to 1.');
        }
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets company
     * @return string
     */
    public function getCompany()
    {
        return $this->container['company'];
    }

    /**
     * Sets company
     * @param string $company The company of the customer address.
     * @return $this
     */
    public function setCompany($company)
    {
        if (strlen($company) > 255) {
            throw new \InvalidArgumentException('invalid length for $company when calling AddressForCustomer., must be smaller than or equal to 255.');
        }
        if (strlen($company) < 0) {
            throw new \InvalidArgumentException('invalid length for $company when calling AddressForCustomer., must be bigger than or equal to 0.');
        }
        $this->container['company'] = $company;

        return $this;
    }

    /**
     * Gets address1
     * @return string
     */
    public function getAddress1()
    {
        return $this->container['address1'];
    }

    /**
     * Sets address1
     * @param string $address1 The address 1 line.
     * @return $this
     */
    public function setAddress1($address1)
    {
        $this->container['address1'] = $address1;

        return $this;
    }

    /**
     * Gets address2
     * @return string
     */
    public function getAddress2()
    {
        return $this->container['address2'];
    }

    /**
     * Sets address2
     * @param string $address2 The address 2 line.
     * @return $this
     */
    public function setAddress2($address2)
    {
        $this->container['address2'] = $address2;

        return $this;
    }

    /**
     * Gets city
     * @return string
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     * @param string $city The city of the customer address.
     * @return $this
     */
    public function setCity($city)
    {
        if (strlen($city) > 100) {
            throw new \InvalidArgumentException('invalid length for $city when calling AddressForCustomer., must be smaller than or equal to 100.');
        }
        if (strlen($city) < 0) {
            throw new \InvalidArgumentException('invalid length for $city when calling AddressForCustomer., must be bigger than or equal to 0.');
        }
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets state_or_province
     * @return string
     */
    public function getStateOrProvince()
    {
        return $this->container['state_or_province'];
    }

    /**
     * Sets state_or_province
     * @param string $state_or_province The state or province name
     * @return $this
     */
    public function setStateOrProvince($state_or_province)
    {
        if (strlen($state_or_province) > 100) {
            throw new \InvalidArgumentException('invalid length for $state_or_province when calling AddressForCustomer., must be smaller than or equal to 100.');
        }
        if (strlen($state_or_province) < 0) {
            throw new \InvalidArgumentException('invalid length for $state_or_province when calling AddressForCustomer., must be bigger than or equal to 0.');
        }
        $this->container['state_or_province'] = $state_or_province;

        return $this;
    }

    /**
     * Gets postal_code
     * @return string
     */
    public function getPostalCode()
    {
        return $this->container['postal_code'];
    }

    /**
     * Sets postal_code
     * @param string $postal_code The postal code of the customer address.
     * @return $this
     */
    public function setPostalCode($postal_code)
    {
        if (strlen($postal_code) > 30) {
            throw new \InvalidArgumentException('invalid length for $postal_code when calling AddressForCustomer., must be smaller than or equal to 30.');
        }
        if (strlen($postal_code) < 0) {
            throw new \InvalidArgumentException('invalid length for $postal_code when calling AddressForCustomer., must be bigger than or equal to 0.');
        }
        $this->container['postal_code'] = $postal_code;

        return $this;
    }

    /**
     * Gets country_code
     * @return string
     */
    public function getCountryCode()
    {
        return $this->container['country_code'];
    }

    /**
     * Sets country_code
     * @param string $country_code The country code of the customer address.
     * @return $this
     */
    public function setCountryCode($country_code)
    {
        if (strlen($country_code) > 2) {
            throw new \InvalidArgumentException('invalid length for $country_code when calling AddressForCustomer., must be smaller than or equal to 2.');
        }
        if (strlen($country_code) < 2) {
            throw new \InvalidArgumentException('invalid length for $country_code when calling AddressForCustomer., must be bigger than or equal to 2.');
        }
        $this->container['country_code'] = $country_code;

        return $this;
    }

    /**
     * Gets phone
     * @return string
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     * @param string $phone The phone number of the customer address.
     * @return $this
     */
    public function setPhone($phone)
    {
        if (strlen($phone) > 50) {
            throw new \InvalidArgumentException('invalid length for $phone when calling AddressForCustomer., must be smaller than or equal to 50.');
        }
        if (strlen($phone) < 0) {
            throw new \InvalidArgumentException('invalid length for $phone when calling AddressForCustomer., must be bigger than or equal to 0.');
        }
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets address_type
     * @return string
     */
    public function getAddressType()
    {
        return $this->container['address_type'];
    }

    /**
     * Sets address_type
     * @param string $address_type The address type. Residential or Commercial
     * @return $this
     */
    public function setAddressType($address_type)
    {
        $allowed_values = ['residential', 'commercial'];
        if (!is_null($address_type) && (!in_array($address_type, $allowed_values))) {
            throw new \InvalidArgumentException("Invalid value for 'address_type', must be one of 'residential', 'commercial'");
        }
        $this->container['address_type'] = $address_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\BigCommerce\Api\v3\ObjectSerializer::sanitizeForSerialization($this));
    }
}


