<?php
/**
 * WidgetApi
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * BigCommerce Widgets API
 *
 * Widgets API allows developers to inject content into a BigCommerce theme.
 *
 * OpenAPI spec version: 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Api;

use \BigCommerce\Api\v3\Configuration;
use \BigCommerce\Api\v3\ApiClient;
use \BigCommerce\Api\v3\ApiException;
use \BigCommerce\Api\v3\ObjectSerializer;

class WidgetApi
{

    /**
     * API Client
     *
     * @var \BigCommerce\Api\v3\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \BigCommerce\Api\v3\ApiClient $apiClient The api client to use
     */
    public function __construct(\BigCommerce\Api\v3\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
    }

    /**
    * Get API client
    *
    * @return \BigCommerce\Api\v3\ApiClient get the API client
    */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
    * Set the API client
    *
    * @param \BigCommerce\Api\v3\ApiClient $apiClient set the API client
    *
    * @return WidgetApi
    */
    public function setApiClient(\BigCommerce\Api\v3\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createLayout
     * Create a Layout
     *
     *
     * @param \BigCommerce\Api\v3\Model\LayoutRequest $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\LayoutResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createLayout($body, array $params = [])
    {
        list($response) = $this->createLayoutWithHttpInfo( $body, $params);
        return $response;
    }


    /**
     * Operation createLayoutWithHttpInfo
     *
     * @see self::createLayout()
     * @param \BigCommerce\Api\v3\Model\LayoutRequest $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\LayoutResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLayoutWithHttpInfo( $body, array $params = [])
    {
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createLayout');
        }
        

        // parse inputs
        $resourcePath = "/content/layouts";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\LayoutResponse',
                '/content/layouts'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\LayoutResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\LayoutResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation createPlacement
     * Create a Placement
     *
     *
     * @param \BigCommerce\Api\v3\Model\PlacementRequest $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\PlacementResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createPlacement($body, array $params = [])
    {
        list($response) = $this->createPlacementWithHttpInfo( $body, $params);
        return $response;
    }


    /**
     * Operation createPlacementWithHttpInfo
     *
     * @see self::createPlacement()
     * @param \BigCommerce\Api\v3\Model\PlacementRequest $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PlacementResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPlacementWithHttpInfo( $body, array $params = [])
    {
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createPlacement');
        }
        

        // parse inputs
        $resourcePath = "/content/placements";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PlacementResponse',
                '/content/placements'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PlacementResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PlacementResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation createWidget
     * Create a Widget
     *
     *
     * @param \BigCommerce\Api\v3\Model\WidgetRequest $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\WidgetResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createWidget($body, array $params = [])
    {
        list($response) = $this->createWidgetWithHttpInfo( $body, $params);
        return $response;
    }


    /**
     * Operation createWidgetWithHttpInfo
     *
     * @see self::createWidget()
     * @param \BigCommerce\Api\v3\Model\WidgetRequest $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\WidgetResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWidgetWithHttpInfo( $body, array $params = [])
    {
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createWidget');
        }
        

        // parse inputs
        $resourcePath = "/content/widgets";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\WidgetResponse',
                '/content/widgets'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\WidgetResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\WidgetResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation createWidgetTemplate
     * Create a Widget Template
     *
     *
     * @param \BigCommerce\Api\v3\Model\WidgetTemplateRequest $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\WidgetTemplateResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createWidgetTemplate($body, array $params = [])
    {
        list($response) = $this->createWidgetTemplateWithHttpInfo( $body, $params);
        return $response;
    }


    /**
     * Operation createWidgetTemplateWithHttpInfo
     *
     * @see self::createWidgetTemplate()
     * @param \BigCommerce\Api\v3\Model\WidgetTemplateRequest $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\WidgetTemplateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWidgetTemplateWithHttpInfo( $body, array $params = [])
    {
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createWidgetTemplate');
        }
        

        // parse inputs
        $resourcePath = "/content/widget-templates";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\WidgetTemplateResponse',
                '/content/widget-templates'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\WidgetTemplateResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\WidgetTemplateResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation deleteLayout
     * Delete a Layout
     *
     *
     * @param string $uuid The identifier for a specific layout. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteLayout($uuid, array $params = [])
    {
        list($response) = $this->deleteLayoutWithHttpInfo($uuid, $params);
        return $response;
    }


    /**
     * Operation deleteLayoutWithHttpInfo
     *
     * @see self::deleteLayout()
     * @param string $uuid The identifier for a specific layout. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLayoutWithHttpInfo($uuid, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling deleteLayout');
        }
        

        // parse inputs
        $resourcePath = "/content/layouts/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/content/layouts/{uuid}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
            }

            throw $e;
        }
    }
    /**
     * Operation deletePlacement
     * Delete a Placement
     *
     *
     * @param string $uuid The identifier for a specific placement. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deletePlacement($uuid, array $params = [])
    {
        list($response) = $this->deletePlacementWithHttpInfo($uuid, $params);
        return $response;
    }


    /**
     * Operation deletePlacementWithHttpInfo
     *
     * @see self::deletePlacement()
     * @param string $uuid The identifier for a specific placement. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePlacementWithHttpInfo($uuid, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling deletePlacement');
        }
        

        // parse inputs
        $resourcePath = "/content/placements/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/content/placements/{uuid}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
            }

            throw $e;
        }
    }
    /**
     * Operation deleteWidget
     * Delete a Widget
     *
     *
     * @param string $uuid The identifier for a specific widget. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteWidget($uuid, array $params = [])
    {
        list($response) = $this->deleteWidgetWithHttpInfo($uuid, $params);
        return $response;
    }


    /**
     * Operation deleteWidgetWithHttpInfo
     *
     * @see self::deleteWidget()
     * @param string $uuid The identifier for a specific widget. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWidgetWithHttpInfo($uuid, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling deleteWidget');
        }
        

        // parse inputs
        $resourcePath = "/content/widgets/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/content/widgets/{uuid}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
            }

            throw $e;
        }
    }
    /**
     * Operation deleteWidgetTemplate
     * Delete A Widget Template
     *
     *
     * @param string $uuid The identifier for a specific template. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteWidgetTemplate($uuid, array $params = [])
    {
        list($response) = $this->deleteWidgetTemplateWithHttpInfo($uuid, $params);
        return $response;
    }


    /**
     * Operation deleteWidgetTemplateWithHttpInfo
     *
     * @see self::deleteWidgetTemplate()
     * @param string $uuid The identifier for a specific template. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWidgetTemplateWithHttpInfo($uuid, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling deleteWidgetTemplate');
        }
        

        // parse inputs
        $resourcePath = "/content/widget-templates/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/content/widget-templates/{uuid}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
            }

            throw $e;
        }
    }
    /**
     * Operation getContentRegions
     * Get Theme Regions
     *
     *
     * @param array $params = []
     *     - template_file string The template file (required)
     * @return \BigCommerce\Api\v3\Model\ThemeRegionsCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getContentRegions(array $params = [])
    {
        list($response) = $this->getContentRegionsWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation getContentRegionsWithHttpInfo
     *
     * @see self::getContentRegions()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\ThemeRegionsCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getContentRegionsWithHttpInfo(array $params = [])
    {
        

        // parse inputs
        $resourcePath = "/content/regions";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\ThemeRegionsCollectionResponse',
                '/content/regions'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\ThemeRegionsCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ThemeRegionsCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation getLayout
     * Get a Layout
     *
     *
     * @param string $uuid The identifier for a specific layout. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\LayoutResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getLayout($uuid, array $params = [])
    {
        list($response) = $this->getLayoutWithHttpInfo($uuid, $params);
        return $response;
    }


    /**
     * Operation getLayoutWithHttpInfo
     *
     * @see self::getLayout()
     * @param string $uuid The identifier for a specific layout. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\LayoutResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLayoutWithHttpInfo($uuid, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling getLayout');
        }
        

        // parse inputs
        $resourcePath = "/content/layouts/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\LayoutResponse',
                '/content/layouts/{uuid}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\LayoutResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\LayoutResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation getLayouts
     * Get All Layouts
     *
     *
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - template_file string The template file (optional)
     * @return \BigCommerce\Api\v3\Model\LayoutCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getLayouts(array $params = [])
    {
        list($response) = $this->getLayoutsWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation getLayoutsWithHttpInfo
     *
     * @see self::getLayouts()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\LayoutCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLayoutsWithHttpInfo(array $params = [])
    {
        

        // parse inputs
        $resourcePath = "/content/layouts";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\LayoutCollectionResponse',
                '/content/layouts'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\LayoutCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\LayoutCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation getPlacement
     * Get a Placement
     *
     *
     * @param string $uuid The identifier for a specific placement. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\PlacementResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getPlacement($uuid, array $params = [])
    {
        list($response) = $this->getPlacementWithHttpInfo($uuid, $params);
        return $response;
    }


    /**
     * Operation getPlacementWithHttpInfo
     *
     * @see self::getPlacement()
     * @param string $uuid The identifier for a specific placement. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PlacementResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPlacementWithHttpInfo($uuid, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling getPlacement');
        }
        

        // parse inputs
        $resourcePath = "/content/placements/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PlacementResponse',
                '/content/placements/{uuid}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PlacementResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PlacementResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation getPlacements
     * Get All Placements
     *
     *
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - widget_template_kind string The kind of widget template. (optional)
     *     - template_file string The template file (optional)
     *     - widget_uuid string The identifier for a specific widget. (optional)
     *     - widget_template_uuid string The identifier for a specific widget template. (optional)
     * @return \BigCommerce\Api\v3\Model\PlacementsCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getPlacements(array $params = [])
    {
        list($response) = $this->getPlacementsWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation getPlacementsWithHttpInfo
     *
     * @see self::getPlacements()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PlacementsCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPlacementsWithHttpInfo(array $params = [])
    {
        

        // parse inputs
        $resourcePath = "/content/placements";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PlacementsCollectionResponse',
                '/content/placements'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PlacementsCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PlacementsCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation getWidget
     * Get a Widget
     *
     *
     * @param string $uuid The identifier for a specific widget. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\WidgetResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getWidget($uuid, array $params = [])
    {
        list($response) = $this->getWidgetWithHttpInfo($uuid, $params);
        return $response;
    }


    /**
     * Operation getWidgetWithHttpInfo
     *
     * @see self::getWidget()
     * @param string $uuid The identifier for a specific widget. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\WidgetResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWidgetWithHttpInfo($uuid, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling getWidget');
        }
        

        // parse inputs
        $resourcePath = "/content/widgets/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\WidgetResponse',
                '/content/widgets/{uuid}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\WidgetResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\WidgetResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation getWidgetTemplate
     * Get a Widget Template
     *
     *
     * @param string $uuid The identifier for a specific template. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\WidgetTemplateResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getWidgetTemplate($uuid, array $params = [])
    {
        list($response) = $this->getWidgetTemplateWithHttpInfo($uuid, $params);
        return $response;
    }


    /**
     * Operation getWidgetTemplateWithHttpInfo
     *
     * @see self::getWidgetTemplate()
     * @param string $uuid The identifier for a specific template. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\WidgetTemplateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWidgetTemplateWithHttpInfo($uuid, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling getWidgetTemplate');
        }
        

        // parse inputs
        $resourcePath = "/content/widget-templates/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\WidgetTemplateResponse',
                '/content/widget-templates/{uuid}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\WidgetTemplateResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\WidgetTemplateResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation getWidgetTemplates
     * Get All Widget Templates
     *
     *
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - widget_template_kind string The kind of widget template. (optional)
     * @return \BigCommerce\Api\v3\Model\WidgetTemplatesCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getWidgetTemplates(array $params = [])
    {
        list($response) = $this->getWidgetTemplatesWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation getWidgetTemplatesWithHttpInfo
     *
     * @see self::getWidgetTemplates()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\WidgetTemplatesCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWidgetTemplatesWithHttpInfo(array $params = [])
    {
        

        // parse inputs
        $resourcePath = "/content/widget-templates";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\WidgetTemplatesCollectionResponse',
                '/content/widget-templates'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\WidgetTemplatesCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\WidgetTemplatesCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation getWidgets
     * Get All Widgets
     *
     *
     * @param array $params = []
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - widget_template_kind string The kind of widget template. (optional)
     *     - widget_template_uuid string The identifier for a specific widget template. (optional)
     * @return \BigCommerce\Api\v3\Model\WidgetCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getWidgets(array $params = [])
    {
        list($response) = $this->getWidgetsWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation getWidgetsWithHttpInfo
     *
     * @see self::getWidgets()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\WidgetCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWidgetsWithHttpInfo(array $params = [])
    {
        

        // parse inputs
        $resourcePath = "/content/widgets";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\WidgetCollectionResponse',
                '/content/widgets'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\WidgetCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\WidgetCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation updateLayout
     * Update a Layout
     *
     *
     * @param string $uuid The identifier for a specific layout. (required)
     * @param \BigCommerce\Api\v3\Model\LayoutRequest $layout_body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\LayoutResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateLayout($uuid, $layout_body, array $params = [])
    {
        list($response) = $this->updateLayoutWithHttpInfo($uuid,  $layout_body, $params);
        return $response;
    }


    /**
     * Operation updateLayoutWithHttpInfo
     *
     * @see self::updateLayout()
     * @param string $uuid The identifier for a specific layout. (required)
     * @param \BigCommerce\Api\v3\Model\LayoutRequest $layout_body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\LayoutResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLayoutWithHttpInfo($uuid,  $layout_body, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling updateLayout');
        }
        
        // verify the required parameter 'layout_body' is set
        if (!isset($layout_body)) {
            throw new \InvalidArgumentException('Missing the required parameter $layout_body when calling updateLayout');
        }
        

        // parse inputs
        $resourcePath = "/content/layouts/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($layout_body)) {
        $_tempBody = $layout_body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\LayoutResponse',
                '/content/layouts/{uuid}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\LayoutResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\LayoutResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation updatePlacement
     * Update a Placement
     *
     *
     * @param string $uuid The identifier for a specific placement. (required)
     * @param \BigCommerce\Api\v3\Model\PlacementRequest $placement_body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\PlacementResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updatePlacement($uuid, $placement_body, array $params = [])
    {
        list($response) = $this->updatePlacementWithHttpInfo($uuid,  $placement_body, $params);
        return $response;
    }


    /**
     * Operation updatePlacementWithHttpInfo
     *
     * @see self::updatePlacement()
     * @param string $uuid The identifier for a specific placement. (required)
     * @param \BigCommerce\Api\v3\Model\PlacementRequest $placement_body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PlacementResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePlacementWithHttpInfo($uuid,  $placement_body, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling updatePlacement');
        }
        
        // verify the required parameter 'placement_body' is set
        if (!isset($placement_body)) {
            throw new \InvalidArgumentException('Missing the required parameter $placement_body when calling updatePlacement');
        }
        

        // parse inputs
        $resourcePath = "/content/placements/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($placement_body)) {
        $_tempBody = $placement_body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PlacementResponse',
                '/content/placements/{uuid}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PlacementResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PlacementResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation updateWidget
     * Update a Widget
     *
     *
     * @param string $uuid The identifier for a specific widget. (required)
     * @param \BigCommerce\Api\v3\Model\WidgetRequest $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\WidgetResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateWidget($uuid, $body, array $params = [])
    {
        list($response) = $this->updateWidgetWithHttpInfo($uuid,  $body, $params);
        return $response;
    }


    /**
     * Operation updateWidgetWithHttpInfo
     *
     * @see self::updateWidget()
     * @param string $uuid The identifier for a specific widget. (required)
     * @param \BigCommerce\Api\v3\Model\WidgetRequest $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\WidgetResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWidgetWithHttpInfo($uuid,  $body, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling updateWidget');
        }
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updateWidget');
        }
        

        // parse inputs
        $resourcePath = "/content/widgets/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\WidgetResponse',
                '/content/widgets/{uuid}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\WidgetResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\WidgetResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation updateWidgetTemplate
     * Update a Widget Template
     *
     *
     * @param string $uuid The identifier for a specific template. (required)
     * @param \BigCommerce\Api\v3\Model\WidgetTemplateRequest $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\WidgetTemplateResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updateWidgetTemplate($uuid, $body, array $params = [])
    {
        list($response) = $this->updateWidgetTemplateWithHttpInfo($uuid,  $body, $params);
        return $response;
    }


    /**
     * Operation updateWidgetTemplateWithHttpInfo
     *
     * @see self::updateWidgetTemplate()
     * @param string $uuid The identifier for a specific template. (required)
     * @param \BigCommerce\Api\v3\Model\WidgetTemplateRequest $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\WidgetTemplateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWidgetTemplateWithHttpInfo($uuid,  $body, array $params = [])
    {
        
        // verify the required parameter 'uuid' is set
        if (!isset($uuid)) {
            throw new \InvalidArgumentException('Missing the required parameter $uuid when calling updateWidgetTemplate');
        }
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling updateWidgetTemplate');
        }
        

        // parse inputs
        $resourcePath = "/content/widget-templates/{uuid}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($uuid)) {
            $resourcePath = str_replace(
                "{" . "uuid" . "}",
                $this->apiClient->getSerializer()->toPathValue($uuid),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\WidgetTemplateResponse',
                '/content/widget-templates/{uuid}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\WidgetTemplateResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\WidgetTemplateResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
}
