<?php
/**
 * SitesApi
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * Sites & Routes
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Api;

use \BigCommerce\Api\v3\Configuration;
use \BigCommerce\Api\v3\ApiClient;
use \BigCommerce\Api\v3\ApiException;
use \BigCommerce\Api\v3\ObjectSerializer;

class SitesApi
{

    /**
     * API Client
     *
     * @var \BigCommerce\Api\v3\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \BigCommerce\Api\v3\ApiClient $apiClient The api client to use
     */
    public function __construct(\BigCommerce\Api\v3\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
    }

    /**
    * Get API client
    *
    * @return \BigCommerce\Api\v3\ApiClient get the API client
    */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
    * Set the API client
    *
    * @param \BigCommerce\Api\v3\ApiClient $apiClient set the API client
    *
    * @return SitesApi
    */
    public function setApiClient(\BigCommerce\Api\v3\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteRoute
     * DELETE Site Route
     *
     *
     * @param string $site_id  (required)
     * @param string $id  (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteRoute($site_id, $id, array $params = [])
    {
        list($response) = $this->deleteRouteWithHttpInfo($site_id, $id, $params);
        return $response;
    }


    /**
     * Operation deleteRouteWithHttpInfo
     *
     * @see self::deleteRoute()
     * @param string $site_id  (required)
     * @param string $id  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRouteWithHttpInfo($site_id, $id, array $params = [])
    {
        
        // verify the required parameter 'site_id' is set
        if (!isset($site_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $site_id when calling deleteRoute');
        }
        
        // verify the required parameter 'id' is set
        if (!isset($id)) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling deleteRoute');
        }
        

        // parse inputs
        $resourcePath = "/sites/{site_id}/routes/{id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($site_id)) {
            $resourcePath = str_replace(
                "{" . "site_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($site_id),
                $resourcePath
            );
        }
        // path params


        if (isset($id)) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/sites/{site_id}/routes/{id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
            }

            throw $e;
        }
    }
    /**
     * Operation deleteSite
     * DELETE Site
     *
     *
     * @param string $id  (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deleteSite($id, array $params = [])
    {
        list($response) = $this->deleteSiteWithHttpInfo($id, $params);
        return $response;
    }


    /**
     * Operation deleteSiteWithHttpInfo
     *
     * @see self::deleteSite()
     * @param string $id  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSiteWithHttpInfo($id, array $params = [])
    {
        
        // verify the required parameter 'id' is set
        if (!isset($id)) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling deleteSite');
        }
        

        // parse inputs
        $resourcePath = "/sites/{id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($id)) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/sites/{id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
            }

            throw $e;
        }
    }
    /**
     * Operation getChannelSite
     * GET Channel Site
     *
     *
     * @param string $channel_id  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\SiteResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getChannelSite($channel_id, array $params = [])
    {
        list($response) = $this->getChannelSiteWithHttpInfo($channel_id, $params);
        return $response;
    }


    /**
     * Operation getChannelSiteWithHttpInfo
     *
     * @see self::getChannelSite()
     * @param string $channel_id  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\SiteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getChannelSiteWithHttpInfo($channel_id, array $params = [])
    {
        
        // verify the required parameter 'channel_id' is set
        if (!isset($channel_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $channel_id when calling getChannelSite');
        }
        

        // parse inputs
        $resourcePath = "/channels/{channel_id}/site";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($channel_id)) {
            $resourcePath = str_replace(
                "{" . "channel_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($channel_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\SiteResponse',
                '/channels/{channel_id}/site'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\SiteResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\SiteResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation getSite
     * GET Site
     *
     *
     * @param string $id  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\SiteResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getSite($id, array $params = [])
    {
        list($response) = $this->getSiteWithHttpInfo($id, $params);
        return $response;
    }


    /**
     * Operation getSiteWithHttpInfo
     *
     * @see self::getSite()
     * @param string $id  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\SiteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSiteWithHttpInfo($id, array $params = [])
    {
        
        // verify the required parameter 'id' is set
        if (!isset($id)) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling getSite');
        }
        

        // parse inputs
        $resourcePath = "/sites/{id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($id)) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\SiteResponse',
                '/sites/{id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\SiteResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\SiteResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation getSiteRoute
     * GET Site Route
     *
     *
     * @param string $site_id  (required)
     * @param string $id  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\RouteResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getSiteRoute($site_id, $id, array $params = [])
    {
        list($response) = $this->getSiteRouteWithHttpInfo($site_id, $id, $params);
        return $response;
    }


    /**
     * Operation getSiteRouteWithHttpInfo
     *
     * @see self::getSiteRoute()
     * @param string $site_id  (required)
     * @param string $id  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\RouteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSiteRouteWithHttpInfo($site_id, $id, array $params = [])
    {
        
        // verify the required parameter 'site_id' is set
        if (!isset($site_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $site_id when calling getSiteRoute');
        }
        
        // verify the required parameter 'id' is set
        if (!isset($id)) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling getSiteRoute');
        }
        

        // parse inputs
        $resourcePath = "/sites/{site_id}/routes/{id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($site_id)) {
            $resourcePath = str_replace(
                "{" . "site_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($site_id),
                $resourcePath
            );
        }
        // path params


        if (isset($id)) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\RouteResponse',
                '/sites/{site_id}/routes/{id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\RouteResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\RouteResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation indexSiteRoutes
     * GET Site Routes
     *
     *
     * @param string $site_id  (required)
     * @param array $params = []
     *     - type string Filter routes by a given resource type (optional)
     * @return \BigCommerce\Api\v3\Model\RouteCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function indexSiteRoutes($site_id, array $params = [])
    {
        list($response) = $this->indexSiteRoutesWithHttpInfo($site_id, $params);
        return $response;
    }


    /**
     * Operation indexSiteRoutesWithHttpInfo
     *
     * @see self::indexSiteRoutes()
     * @param string $site_id  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\RouteCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function indexSiteRoutesWithHttpInfo($site_id, array $params = [])
    {
        
        // verify the required parameter 'site_id' is set
        if (!isset($site_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $site_id when calling indexSiteRoutes');
        }
        

        // parse inputs
        $resourcePath = "/sites/{site_id}/routes";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($site_id)) {
            $resourcePath = str_replace(
                "{" . "site_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($site_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\RouteCollectionResponse',
                '/sites/{site_id}/routes'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\RouteCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\RouteCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation postChannelSite
     * POST Channel Site
     *
     *
     * @param string $channel_id  (required)
     * @param \BigCommerce\Api\v3\Model\SiteCreateRequest $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\SiteResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function postChannelSite($channel_id, $body, array $params = [])
    {
        list($response) = $this->postChannelSiteWithHttpInfo($channel_id,  $body, $params);
        return $response;
    }


    /**
     * Operation postChannelSiteWithHttpInfo
     *
     * @see self::postChannelSite()
     * @param string $channel_id  (required)
     * @param \BigCommerce\Api\v3\Model\SiteCreateRequest $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\SiteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postChannelSiteWithHttpInfo($channel_id,  $body, array $params = [])
    {
        
        // verify the required parameter 'channel_id' is set
        if (!isset($channel_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $channel_id when calling postChannelSite');
        }
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postChannelSite');
        }
        

        // parse inputs
        $resourcePath = "/channels/{channel_id}/site";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($channel_id)) {
            $resourcePath = str_replace(
                "{" . "channel_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($channel_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\SiteResponse',
                '/channels/{channel_id}/site'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\SiteResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 201:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\SiteResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation postSite
     * POST Site
     *
     *
     * @param \BigCommerce\Api\v3\Model\SiteCreateRequest $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\SiteResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function postSite($body, array $params = [])
    {
        list($response) = $this->postSiteWithHttpInfo( $body, $params);
        return $response;
    }


    /**
     * Operation postSiteWithHttpInfo
     *
     * @see self::postSite()
     * @param \BigCommerce\Api\v3\Model\SiteCreateRequest $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\SiteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSiteWithHttpInfo( $body, array $params = [])
    {
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postSite');
        }
        

        // parse inputs
        $resourcePath = "/sites";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\SiteResponse',
                '/sites'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\SiteResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\SiteResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation postSiteRoute
     * POST Site Route
     *
     *
     * @param string $site_id  (required)
     * @param \BigCommerce\Api\v3\Model\Route $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\RouteResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function postSiteRoute($site_id, $body, array $params = [])
    {
        list($response) = $this->postSiteRouteWithHttpInfo($site_id,  $body, $params);
        return $response;
    }


    /**
     * Operation postSiteRouteWithHttpInfo
     *
     * @see self::postSiteRoute()
     * @param string $site_id  (required)
     * @param \BigCommerce\Api\v3\Model\Route $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\RouteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSiteRouteWithHttpInfo($site_id,  $body, array $params = [])
    {
        
        // verify the required parameter 'site_id' is set
        if (!isset($site_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $site_id when calling postSiteRoute');
        }
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling postSiteRoute');
        }
        

        // parse inputs
        $resourcePath = "/sites/{site_id}/routes";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($site_id)) {
            $resourcePath = str_replace(
                "{" . "site_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($site_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\RouteResponse',
                '/sites/{site_id}/routes'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\RouteResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 201:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\RouteResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation putChannelSite
     * PUT Channel Site
     *
     *
     * @param string $channel_id  (required)
     * @param \BigCommerce\Api\v3\Model\Site $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\SiteResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function putChannelSite($channel_id, $body, array $params = [])
    {
        list($response) = $this->putChannelSiteWithHttpInfo($channel_id,  $body, $params);
        return $response;
    }


    /**
     * Operation putChannelSiteWithHttpInfo
     *
     * @see self::putChannelSite()
     * @param string $channel_id  (required)
     * @param \BigCommerce\Api\v3\Model\Site $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\SiteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function putChannelSiteWithHttpInfo($channel_id,  $body, array $params = [])
    {
        
        // verify the required parameter 'channel_id' is set
        if (!isset($channel_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $channel_id when calling putChannelSite');
        }
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putChannelSite');
        }
        

        // parse inputs
        $resourcePath = "/channels/{channel_id}/site";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($channel_id)) {
            $resourcePath = str_replace(
                "{" . "channel_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($channel_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\SiteResponse',
                '/channels/{channel_id}/site'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\SiteResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 201:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\SiteResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation putSite
     * PUT Site
     *
     *
     * @param string $id  (required)
     * @param \BigCommerce\Api\v3\Model\Site $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\SiteResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function putSite($id, $body, array $params = [])
    {
        list($response) = $this->putSiteWithHttpInfo($id,  $body, $params);
        return $response;
    }


    /**
     * Operation putSiteWithHttpInfo
     *
     * @see self::putSite()
     * @param string $id  (required)
     * @param \BigCommerce\Api\v3\Model\Site $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\SiteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSiteWithHttpInfo($id,  $body, array $params = [])
    {
        
        // verify the required parameter 'id' is set
        if (!isset($id)) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling putSite');
        }
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putSite');
        }
        

        // parse inputs
        $resourcePath = "/sites/{id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($id)) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\SiteResponse',
                '/sites/{id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\SiteResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\SiteResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
    /**
     * Operation putSiteRoute
     * PUT Site Route
     *
     *
     * @param string $site_id  (required)
     * @param string $id  (required)
     * @param \BigCommerce\Api\v3\Model\Route $body  (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\RouteResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function putSiteRoute($site_id, $id, $body, array $params = [])
    {
        list($response) = $this->putSiteRouteWithHttpInfo($site_id, $id,  $body, $params);
        return $response;
    }


    /**
     * Operation putSiteRouteWithHttpInfo
     *
     * @see self::putSiteRoute()
     * @param string $site_id  (required)
     * @param string $id  (required)
     * @param \BigCommerce\Api\v3\Model\Route $body  (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\RouteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSiteRouteWithHttpInfo($site_id, $id,  $body, array $params = [])
    {
        
        // verify the required parameter 'site_id' is set
        if (!isset($site_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $site_id when calling putSiteRoute');
        }
        
        // verify the required parameter 'id' is set
        if (!isset($id)) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling putSiteRoute');
        }
        
        // verify the required parameter 'body' is set
        if (!isset($body)) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling putSiteRoute');
        }
        

        // parse inputs
        $resourcePath = "/sites/{site_id}/routes/{id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($site_id)) {
            $resourcePath = str_replace(
                "{" . "site_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($site_id),
                $resourcePath
            );
        }
        // path params


        if (isset($id)) {
            $resourcePath = str_replace(
                "{" . "id" . "}",
                $this->apiClient->getSerializer()->toPathValue($id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
        $_tempBody = $body;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\RouteResponse',
                '/sites/{site_id}/routes/{id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\RouteResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {
            
                case 201:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\RouteResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            
            }

            throw $e;
        }
    }
}
