<?php
/**
 * PriceListsApi
 *
 * @package  BigCommerce\Api\v3
 */

/**
 * BigCommerce API
 *
 * A Swagger Document for the BigCommmerce v3 API.
 *
 * OpenAPI spec version: 3.0.0b
 *
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace BigCommerce\Api\v3\Api;

use \BigCommerce\Api\v3\Configuration;
use \BigCommerce\Api\v3\ApiClient;
use \BigCommerce\Api\v3\ApiException;
use \BigCommerce\Api\v3\ObjectSerializer;

class PriceListsApi
{

    /**
     * API Client
     *
     * @var \BigCommerce\Api\v3\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \BigCommerce\Api\v3\ApiClient $apiClient The api client to use
     */
    public function __construct(\BigCommerce\Api\v3\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
    }

    /**
    * Get API client
    *
    * @return \BigCommerce\Api\v3\ApiClient get the API client
    */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
    * Set the API client
    *
    * @param \BigCommerce\Api\v3\ApiClient $apiClient set the API client
    *
    * @return PriceListsApi
    */
    public function setApiClient(\BigCommerce\Api\v3\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createPriceList
     *
     *
     *
     * @param \BigCommerce\Api\v3\Model\PriceListPost $price_list A BigCommerce &#x60;PriceList&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\PriceListResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function createPriceList($price_list, array $params = [])
    {
        list($response) = $this->createPriceListWithHttpInfo( $price_list, $params);
        return $response;
    }


    /**
     * Operation createPriceListWithHttpInfo
     *
     * @see self::createPriceList()
     * @param \BigCommerce\Api\v3\Model\PriceListPost $price_list A BigCommerce &#x60;PriceList&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PriceListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPriceListWithHttpInfo( $price_list, array $params = [])
    {

        // verify the required parameter 'price_list' is set
        if (!isset($price_list)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list when calling createPriceList');
        }


        // parse inputs
        $resourcePath = "/pricelists";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($price_list)) {
        $_tempBody = $price_list;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PriceListResponse',
                '/pricelists'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PriceListResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PriceListResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation deletePriceList
     *
     *
     *
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deletePriceList($price_list_id, array $params = [])
    {
        list($response) = $this->deletePriceListWithHttpInfo($price_list_id, $params);
        return $response;
    }


    /**
     * Operation deletePriceListWithHttpInfo
     *
     * @see self::deletePriceList()
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePriceListWithHttpInfo($price_list_id, array $params = [])
    {

        // verify the required parameter 'price_list_id' is set
        if (!isset($price_list_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list_id when calling deletePriceList');
        }


        // parse inputs
        $resourcePath = "/pricelists/{price_list_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($price_list_id)) {
            $resourcePath = str_replace(
                "{" . "price_list_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($price_list_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/pricelists/{price_list_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deletePriceListRecord
     *
     *
     *
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param string $currency_code The currency code associated with the price record being acted upon. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deletePriceListRecord($price_list_id, $variant_id, $currency_code, array $params = [])
    {
        list($response) = $this->deletePriceListRecordWithHttpInfo($price_list_id, $variant_id, $currency_code, $params);
        return $response;
    }


    /**
     * Operation deletePriceListRecordWithHttpInfo
     *
     * @see self::deletePriceListRecord()
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param string $currency_code The currency code associated with the price record being acted upon. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePriceListRecordWithHttpInfo($price_list_id, $variant_id, $currency_code, array $params = [])
    {

        // verify the required parameter 'price_list_id' is set
        if (!isset($price_list_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list_id when calling deletePriceListRecord');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling deletePriceListRecord');
        }

        // verify the required parameter 'currency_code' is set
        if (!isset($currency_code)) {
            throw new \InvalidArgumentException('Missing the required parameter $currency_code when calling deletePriceListRecord');
        }


        // parse inputs
        $resourcePath = "/pricelists/{price_list_id}/records/{variant_id}/{currency_code}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($price_list_id)) {
            $resourcePath = str_replace(
                "{" . "price_list_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($price_list_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // path params


        if (isset($currency_code)) {
            $resourcePath = str_replace(
                "{" . "currency_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($currency_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/pricelists/{price_list_id}/records/{variant_id}/{currency_code}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deletePriceListRecordsByFilter
     *
     *
     *
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param array $params = []
     *     - variant_id int The ID of the &#x60;Variant&#x60; whose prices were requested. (optional)
     * @return \BigCommerce\Api\v3\Model\NoContent
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deletePriceListRecordsByFilter($price_list_id, array $params = [])
    {
        list($response) = $this->deletePriceListRecordsByFilterWithHttpInfo($price_list_id, $params);
        return $response;
    }


    /**
     * Operation deletePriceListRecordsByFilterWithHttpInfo
     *
     * @see self::deletePriceListRecordsByFilter()
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\NoContent, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePriceListRecordsByFilterWithHttpInfo($price_list_id, array $params = [])
    {

        // verify the required parameter 'price_list_id' is set
        if (!isset($price_list_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list_id when calling deletePriceListRecordsByFilter');
        }


        // parse inputs
        $resourcePath = "/pricelists/{price_list_id}/records";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($price_list_id)) {
            $resourcePath = str_replace(
                "{" . "price_list_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($price_list_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\NoContent',
                '/pricelists/{price_list_id}/records'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\NoContent', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 204:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NoContent', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation deletePriceListRecordsByVariantId
     *
     *
     *
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deletePriceListRecordsByVariantId($price_list_id, $variant_id, array $params = [])
    {
        list($response) = $this->deletePriceListRecordsByVariantIdWithHttpInfo($price_list_id, $variant_id, $params);
        return $response;
    }


    /**
     * Operation deletePriceListRecordsByVariantIdWithHttpInfo
     *
     * @see self::deletePriceListRecordsByVariantId()
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePriceListRecordsByVariantIdWithHttpInfo($price_list_id, $variant_id, array $params = [])
    {

        // verify the required parameter 'price_list_id' is set
        if (!isset($price_list_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list_id when calling deletePriceListRecordsByVariantId');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling deletePriceListRecordsByVariantId');
        }


        // parse inputs
        $resourcePath = "/pricelists/{price_list_id}/records/{variant_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($price_list_id)) {
            $resourcePath = str_replace(
                "{" . "price_list_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($price_list_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/pricelists/{price_list_id}/records/{variant_id}'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation deletePriceListsByFilter
     *
     *
     *
     * @param array $params = []
     *     - id int Filter items by id. (optional)
     *     - name string Filter items by name. (optional)
     * @return null
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function deletePriceListsByFilter(array $params = [])
    {
        list($response) = $this->deletePriceListsByFilterWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation deletePriceListsByFilterWithHttpInfo
     *
     * @see self::deletePriceListsByFilter()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePriceListsByFilterWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/pricelists";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/pricelists'
            );
            return [null, $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

            }

            throw $e;
        }
    }
    /**
     * Operation getPriceList
     *
     *
     *
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\PriceListResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getPriceList($price_list_id, array $params = [])
    {
        list($response) = $this->getPriceListWithHttpInfo($price_list_id, $params);
        return $response;
    }


    /**
     * Operation getPriceListWithHttpInfo
     *
     * @see self::getPriceList()
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PriceListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPriceListWithHttpInfo($price_list_id, array $params = [])
    {

        // verify the required parameter 'price_list_id' is set
        if (!isset($price_list_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list_id when calling getPriceList');
        }


        // parse inputs
        $resourcePath = "/pricelists/{price_list_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($price_list_id)) {
            $resourcePath = str_replace(
                "{" . "price_list_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($price_list_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PriceListResponse',
                '/pricelists/{price_list_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PriceListResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PriceListResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getPriceListCollection
     *
     *
     *
     * @param array $params = []
     *     - id int Filter items by id. (optional)
     *     - name string Filter items by name. (optional)
     *     - date_created \DateTime Filter items by date_created. (optional)
     *     - date_modified \DateTime Filter items by date_modified. (optional)
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @return \BigCommerce\Api\v3\Model\PriceListCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getPriceListCollection(array $params = [])
    {
        list($response) = $this->getPriceListCollectionWithHttpInfo($params);
        return $response;
    }


    /**
     * Operation getPriceListCollectionWithHttpInfo
     *
     * @see self::getPriceListCollection()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PriceListCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPriceListCollectionWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/pricelists";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PriceListCollectionResponse',
                '/pricelists'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PriceListCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PriceListCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }

    /**
     * Operation getPriceListCollection
     *
     *
     *
     * @param array $params = []
     *     - channel_id int Filter items by channel_id. (optional)
     *     - channel_id:in int Filter items by channel_id. (optional)\
     *     - id int Filter items by id. (optional)
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     * @return \BigCommerce\Api\v3\Model\PriceListCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getPriceListCollectionAssignments(array $params = [])
    {
        list($response) = $this->getPriceListCollectionAssignmentsWithHttpInfo($params);
        return $response;
    }

    /**
     * Operation getPriceListCollectionAssignmentsWithHttpInfo
     *
     * @see self::getPriceListCollection()
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PriceListCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPriceListCollectionAssignmentsWithHttpInfo(array $params = [])
    {


        // parse inputs
        $resourcePath = "/pricelists/assignments";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PriceListCollectionResponse',
                '/pricelists'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PriceListCollectionAssignmentsResponse', $httpHeader), $statusCode, $httpHeader];

        } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PriceListCollectionAssignmentsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;

            }

            throw $e;
        }
    }
    /**
     * Operation getPriceListRecord
     *
     *
     *
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param string $currency_code The currency code associated with the price record being acted upon. (required)
     * @param array $params = []
     *     - include string Sub-resources to include on a price record, in a comma-separated list. Valid expansions currently include &#x60;bulk_pricing_tiers&#x60; and &#x60;sku&#x60;.  Other valies will be ignored. (optional)
     * @return \BigCommerce\Api\v3\Model\PriceRecordResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getPriceListRecord($price_list_id, $variant_id, $currency_code, array $params = [])
    {
        list($response) = $this->getPriceListRecordWithHttpInfo($price_list_id, $variant_id, $currency_code, $params);
        return $response;
    }


    /**
     * Operation getPriceListRecordWithHttpInfo
     *
     * @see self::getPriceListRecord()
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param string $currency_code The currency code associated with the price record being acted upon. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PriceRecordResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPriceListRecordWithHttpInfo($price_list_id, $variant_id, $currency_code, array $params = [])
    {

        // verify the required parameter 'price_list_id' is set
        if (!isset($price_list_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list_id when calling getPriceListRecord');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling getPriceListRecord');
        }

        // verify the required parameter 'currency_code' is set
        if (!isset($currency_code)) {
            throw new \InvalidArgumentException('Missing the required parameter $currency_code when calling getPriceListRecord');
        }


        // parse inputs
        $resourcePath = "/pricelists/{price_list_id}/records/{variant_id}/{currency_code}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($price_list_id)) {
            $resourcePath = str_replace(
                "{" . "price_list_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($price_list_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // path params


        if (isset($currency_code)) {
            $resourcePath = str_replace(
                "{" . "currency_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($currency_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PriceRecordResponse',
                '/pricelists/{price_list_id}/records/{variant_id}/{currency_code}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PriceRecordResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PriceRecordResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getPriceListRecordCollection
     *
     *
     *
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param array $params = []
     *     - variant_id int The ID of the &#x60;Variant&#x60; whose prices were requested. (optional)
     *     - product_id string A comma-separated list of ids of &#x60;Product&#x60;s whose prices were requested. (optional)
     *     - currency string Filter items by currency. (optional)
     *     - page int Specifies the page number in a limited (paginated) list of products. (optional)
     *     - limit int Controls the number of items per page in a limited (paginated) list of products. (optional)
     *     - include string Sub-resources to include on a price record, in a comma-separated list. Valid expansions currently include &#x60;bulk_pricing_tiers&#x60; and &#x60;sku&#x60;.  Other valies will be ignored. (optional)
     *     - price float Filter items by price. (optional)
     *     - sale_price float Filter items by sale_price. (optional)
     *     - retail_price float Filter items by retail_price. (optional)
     *     - map_price float Filter items by map_price. (optional)
     *     - calculated_price float Filter items by calculated_price. (optional)
     *     - date_created \DateTime Filter items by date_created. (optional)
     *     - date_modified \DateTime Filter items by date_modified. (optional)
     *     - sku string Filter items by sku. (optional)
     * @return \BigCommerce\Api\v3\Model\PriceRecordCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getPriceListRecordCollection($price_list_id, array $params = [])
    {
        list($response) = $this->getPriceListRecordCollectionWithHttpInfo($price_list_id, $params);
        return $response;
    }


    /**
     * Operation getPriceListRecordCollectionWithHttpInfo
     *
     * @see self::getPriceListRecordCollection()
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PriceRecordCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPriceListRecordCollectionWithHttpInfo($price_list_id, array $params = [])
    {

        // verify the required parameter 'price_list_id' is set
        if (!isset($price_list_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list_id when calling getPriceListRecordCollection');
        }


        // parse inputs
        $resourcePath = "/pricelists/{price_list_id}/records";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($price_list_id)) {
            $resourcePath = str_replace(
                "{" . "price_list_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($price_list_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PriceRecordCollectionResponse',
                '/pricelists/{price_list_id}/records'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PriceRecordCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PriceRecordCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation getPriceListRecordsByVariantId
     *
     *
     *
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\PriceRecordCollectionResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function getPriceListRecordsByVariantId($price_list_id, $variant_id, array $params = [])
    {
        list($response) = $this->getPriceListRecordsByVariantIdWithHttpInfo($price_list_id, $variant_id, $params);
        return $response;
    }


    /**
     * Operation getPriceListRecordsByVariantIdWithHttpInfo
     *
     * @see self::getPriceListRecordsByVariantId()
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PriceRecordCollectionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPriceListRecordsByVariantIdWithHttpInfo($price_list_id, $variant_id, array $params = [])
    {

        // verify the required parameter 'price_list_id' is set
        if (!isset($price_list_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list_id when calling getPriceListRecordsByVariantId');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling getPriceListRecordsByVariantId');
        }


        // parse inputs
        $resourcePath = "/pricelists/{price_list_id}/records/{variant_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($price_list_id)) {
            $resourcePath = str_replace(
                "{" . "price_list_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($price_list_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PriceRecordCollectionResponse',
                '/pricelists/{price_list_id}/records/{variant_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PriceRecordCollectionResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PriceRecordCollectionResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation setPriceListRecord
     *
     *
     *
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param string $currency_code The currency code associated with the price record being acted upon. (required)
     * @param \BigCommerce\Api\v3\Model\PriceRecordPut $price_record A BigCommerce &#x60;Price Record&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\PriceRecordResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function setPriceListRecord($price_list_id, $variant_id, $currency_code, $price_record, array $params = [])
    {
        list($response) = $this->setPriceListRecordWithHttpInfo($price_list_id, $variant_id, $currency_code,  $price_record, $params);
        return $response;
    }


    /**
     * Operation setPriceListRecordWithHttpInfo
     *
     * @see self::setPriceListRecord()
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param int $variant_id ID of the variant on a product, or on an associated Price List Record. (required)
     * @param string $currency_code The currency code associated with the price record being acted upon. (required)
     * @param \BigCommerce\Api\v3\Model\PriceRecordPut $price_record A BigCommerce &#x60;Price Record&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PriceRecordResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function setPriceListRecordWithHttpInfo($price_list_id, $variant_id, $currency_code,  $price_record, array $params = [])
    {

        // verify the required parameter 'price_list_id' is set
        if (!isset($price_list_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list_id when calling setPriceListRecord');
        }

        // verify the required parameter 'variant_id' is set
        if (!isset($variant_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $variant_id when calling setPriceListRecord');
        }

        // verify the required parameter 'currency_code' is set
        if (!isset($currency_code)) {
            throw new \InvalidArgumentException('Missing the required parameter $currency_code when calling setPriceListRecord');
        }

        // verify the required parameter 'price_record' is set
        if (!isset($price_record)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_record when calling setPriceListRecord');
        }


        // parse inputs
        $resourcePath = "/pricelists/{price_list_id}/records/{variant_id}/{currency_code}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($price_list_id)) {
            $resourcePath = str_replace(
                "{" . "price_list_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($price_list_id),
                $resourcePath
            );
        }
        // path params


        if (isset($variant_id)) {
            $resourcePath = str_replace(
                "{" . "variant_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($variant_id),
                $resourcePath
            );
        }
        // path params


        if (isset($currency_code)) {
            $resourcePath = str_replace(
                "{" . "currency_code" . "}",
                $this->apiClient->getSerializer()->toPathValue($currency_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($price_record)) {
        $_tempBody = $price_record;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PriceRecordResponse',
                '/pricelists/{price_list_id}/records/{variant_id}/{currency_code}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PriceRecordResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PriceRecordResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation setPriceListRecordCollection
     *
     *
     *
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param \BigCommerce\Api\v3\Model\PriceRecordCollectionPut $price_record_batch A BigCommerce &#x60;Price Record&#x60; request. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\SuccessBatchResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function setPriceListRecordCollection($price_list_id, $price_record_batch, array $params = [])
    {
        list($response) = $this->setPriceListRecordCollectionWithHttpInfo($price_list_id,  $price_record_batch, $params);
        return $response;
    }


    /**
     * Operation setPriceListRecordCollectionWithHttpInfo
     *
     * @see self::setPriceListRecordCollection()
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param \BigCommerce\Api\v3\Model\PriceRecordCollectionPut $price_record_batch A BigCommerce &#x60;Price Record&#x60; request. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\SuccessBatchResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function setPriceListRecordCollectionWithHttpInfo($price_list_id,  $price_record_batch, array $params = [])
    {

        // verify the required parameter 'price_list_id' is set
        if (!isset($price_list_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list_id when calling setPriceListRecordCollection');
        }

        // verify the required parameter 'price_record_batch' is set
        if (!isset($price_record_batch)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_record_batch when calling setPriceListRecordCollection');
        }



        // parse inputs
        $resourcePath = "/pricelists/{price_list_id}/records";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);
        // header params

        if (isset($x_strict_mode)) {
            $headerParams['X-Strict-Mode'] = $this->apiClient->getSerializer()->toHeaderValue($x_strict_mode);
        }

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($price_list_id)) {
            $resourcePath = str_replace(
                "{" . "price_list_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($price_list_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($price_record_batch)) {
        $_tempBody = $price_record_batch;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\SuccessBatchResponse',
                '/pricelists/{price_list_id}/records'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\SuccessBatchResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\SuccessBatchResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PriceRecordBatchErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
    /**
     * Operation updatePriceList
     *
     *
     *
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param \BigCommerce\Api\v3\Model\PriceListPut $price_list A BigCommerce &#x60;Price List&#x60; object. (required)
     * @param array $params = []
     * @return \BigCommerce\Api\v3\Model\PriceListResponse
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     */
    public function updatePriceList($price_list_id, $price_list, array $params = [])
    {
        list($response) = $this->updatePriceListWithHttpInfo($price_list_id,  $price_list, $params);
        return $response;
    }


    /**
     * Operation updatePriceListWithHttpInfo
     *
     * @see self::updatePriceList()
     * @param int $price_list_id The ID of the &#x60;Price List&#x60; requested. (required)
     * @param \BigCommerce\Api\v3\Model\PriceListPut $price_list A BigCommerce &#x60;Price List&#x60; object. (required)
     * @param array $params = []
     * @throws \BigCommerce\Api\v3\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \BigCommerce\Api\v3\Model\PriceListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePriceListWithHttpInfo($price_list_id,  $price_list, array $params = [])
    {

        // verify the required parameter 'price_list_id' is set
        if (!isset($price_list_id)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list_id when calling updatePriceList');
        }

        // verify the required parameter 'price_list' is set
        if (!isset($price_list)) {
            throw new \InvalidArgumentException('Missing the required parameter $price_list when calling updatePriceList');
        }


        // parse inputs
        $resourcePath = "/pricelists/{price_list_id}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json']);

        // query params
        foreach ( $params as $key => $param ) {
            $queryParams[ $key ] = $this->apiClient->getSerializer()->toQueryValue( $param );
        }

        // path params


        if (isset($price_list_id)) {
            $resourcePath = str_replace(
                "{" . "price_list_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($price_list_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($price_list)) {
        $_tempBody = $price_list;
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }

        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\BigCommerce\Api\v3\Model\PriceListResponse',
                '/pricelists/{price_list_id}'
            );
            return [$this->apiClient->getSerializer()->deserialize($response, '\BigCommerce\Api\v3\Model\PriceListResponse', $httpHeader), $statusCode, $httpHeader];

         } catch (ApiException $e) {
            switch ($e->getCode()) {

                case 200:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\PriceListResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 404:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\NotFound', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 409:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

                case 422:
                $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\BigCommerce\Api\v3\Model\ErrorResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;

            }

            throw $e;
        }
    }
}
