# Contributing to the BigCommerce WordPress plugin

Thanks for your interest in contributing to the Wordpress for BigCommerce plugin!

The following is a set of guidelines for contributing to the project. These are just guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

By contributing to the Wordpress for BigCommerce plugin, you agree that your contributions will be licensed as listed under the README.md.

#### Table of Contents

[How Can I Contribute?](#how-can-i-contribute)
  * [Your First Code Contribution](#your-first-code-contribution)
  * [Pull Requests](#pull-requests)

[Styleguides](#styleguides)
  * [Git Commit Messages](#git-commit-messages)

### Your First Code Contribution

Unsure where to begin contributing? Check our [Community group](https://forum.bigcommerce.com/s/group/0F91B000000922sSAA/developers-early-access-beta), GitHub Issues, or contribute to our documentation.

### Pull Requests

* Fill in [the required template](https://github.com/bigcommerce/bigcommerce-for-wordpress/pull/new/master)
* Include screenshots and animated GIFs in your pull request whenever possible.
* End files with a newline.

## Styleguides

### Git Commit Messages

* Use the present tense ("Add feature" not "Added feature")
* Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
* Limit the first line to 72 characters or less
* Reference pull requests and external links liberally